#ifndef INCLUDED_Serializer_h
#define INCLUDED_Serializer_h

//!provides a default serializer base class for simple objects
class Serializer {
public:
  
protected:
	//! writes @a value to @a dst and advances @a dst
  template<class T>
  inline static void encode(char **dst, T value) {
    memcpy(*dst, (char *)&value, sizeof(T));
//    hostToNetwork(*dst, (char *)&value, sizeof(T));
//    it'd be nice to use network byte order, but we'll save the aibo
//    extra work
    (*dst) += sizeof(T);
  }

	//! converts to network byte order (big endian - aibo is little endian)
  inline static void hostToNetwork(char *dst, char *src, int length) {
    for (int i=0; i<length; i++)
      dst[length-1-i]=src[i];
  }

	//! writes @a length bytes from @a src to @a dst
  inline static void encode(char **dst, char *src, int length) {
    memcpy(*dst, src, length);
    (*dst) +=length;
  }

	//! a simple form of compression - calls encode(@a dst,float(@a src[i])) for i=0..@a length
  inline static void encodeDoublesAsFloats(char **dst, double *src, int length) {
    for (int i=0; i<length; i++)
      encode(dst, float(src[i]));
  }
};

/*! @file
 * @brief Defines the Serializer base class, which provides a default serializer for simple objects
 * @author alokl (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_3 $
 * $Revision: 1.4 $
 * $State: Exp $
 * $Date: 2003/06/12 18:06:11 $
 */

#endif
