//-*-c++-*-
#ifndef INCLUDED_RobotInfo_h
#define INCLUDED_RobotInfo_h

#if TGT_ERS220
#	include "ERS220Info.h"
#elif TGT_ERS210
#	include "ERS210Info.h"
#else //default case, ERS2xx
#	if TGT_ERS2xx==0
#		warning "TGT_<model> undefined - defaulting to ERS2xx"
#	endif
#	include "ERS2xxInfo.h"
#endif //model selection

//! Contains information about the robot, such as number of joints, PID defaults, timing information, etc.
namespace RobotInfo {

#if TGT_ERS220
	using namespace ERS220Info;
#elif TGT_ERS210
	using namespace ERS210Info;
#else //default case, ERS2xx
	using namespace ERS2xxInfo;
#endif //model selection

}

using namespace RobotInfo;
	
/*! @file
 * @brief Checks the define's to load the appropriate header and namespace
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_3 $
 * $Revision: 1.12 $
 * $State: Exp $
 * $Date: 2003/06/11 01:18:56 $
 */

#endif
