#include "LoadSave.h"
#include <iostream>
#include <string.h>

LoadSave::~LoadSave() {}

unsigned int LoadSave::checkCreator(const char* creator, const char buf[], unsigned int len, bool isLoading) const {
	unsigned int sz=0,last;
	char* type=NULL;
	if(!(last=decode(type,buf+sz,len))) return 0; else sz+=last;
	if(strncmp(type,creator,strlen(creator))!=0) {
		if(isLoading)
			std::cout << "*** WARNING " << creator << "::LoadBuffer - corruption detected" << std::endl;
		return 0;
	}
	delete [] type;
	return sz;
}

unsigned int LoadSave::checkCreator(const char* creator, FILE* f, bool isLoading) const {
	unsigned int sz=0,last;
	unsigned int origpos=ftell(f);
	char* type=NULL;
	if(!(last=decode(type,f))) {
		fseek(f,origpos,SEEK_SET);
		return 0;
	} else
		sz+=last;
	if(strncmp(type,creator,strlen(creator))!=0) {
		if(isLoading)
			std::cout << "*** WARNING " << creator << "::LoadBuffer - corruption detected" << std::endl;
		fseek(f,origpos,SEEK_SET);
		return 0;
	}
	delete [] type;	
	return sz;
}

unsigned int LoadSave::saveCreator(const char* creator, char buf[], unsigned int len) const {
	return encode(std::string(creator),buf,len);
}

unsigned int LoadSave::saveCreator(const char* creator, FILE* f) const {
	return encode(creator,f);
}

unsigned int LoadSave::LoadFile(const char* file) {
	int err;
	std::cout << "Loading: " << file << std::endl;
	FILE* f = fopen(file,"r");
	if(f==NULL) {
		std::cout << "*** WARNING could not open file for loading \"" << file << "\"" << std::endl;
		return 0;
	}
	unsigned int sz = LoadFile(f);
	if(sz==0)
		std::cout << "*** WARNING loading of " << file << " failed " << std::endl;
	err=fclose(f);
	if(err!=0) {
		std::cout << "*** WARNING error " << err << " while closing " << file << std::endl;
		return 0;
	}
	return sz;
}
unsigned int LoadSave::SaveFile(const char* file) const {
	int err;
	std::cout << "Saving: " << file << std::endl;
	FILE* f = fopen(file,"w");
	if(f==NULL) {
		std::cout << "*** WARNING could not open file for saving \"" << file << "\"" << std::endl;
		return 0;
	}
	unsigned int sz = SaveFile(f);
	if(sz==0)
		std::cout << "*** WARNING saving of " << file << " failed " << std::endl;
	err=fclose(f);
	if(err!=0) {
		std::cout << "*** WARNING error " << err << " while closing " << file << std::endl;
		return 0;
	}
	return sz;
}

unsigned int LoadSave::LoadFile(FILE* f) {
	unsigned int cap=128;
	unsigned int sz=0;
	unsigned int origpos=ftell(f);
	char * buf = new char[cap];
	if(buf==NULL) {
		std::cout << "*** WARNING could not allocate " << cap << "+ bytes for LoadFile";
		return 0;
	}
	unsigned int read=fread(&buf[sz],1,cap-sz,f);
	while(read==cap-sz) {
		char * newbuf = new char[cap*2];
		if(newbuf==NULL) {
			std::cout << "*** WARNING could not allocate " << cap*2 << "+ bytes for LoadFile";
			return 0;
		}
		memcpy(newbuf,buf,cap);
		delete [] buf;
		buf=newbuf;
		sz=cap;
		cap*=2;
		read=fread(&buf[sz],1,cap-sz,f);
	}
	sz+=read;
	unsigned int resp=LoadBuffer(buf,sz);
	delete [] buf;
	if(resp!=sz)
		fseek(f,origpos+resp,SEEK_SET);
	return resp;
}
unsigned int LoadSave::SaveFile(FILE* f) const {
	unsigned int sz=getBinSize();
	char * buf = new char[sz];
	memset(buf,0xF0,sz);
	if(buf==NULL) {
		std::cout << "*** WARNING could not allocate " << sz << " bytes for LoadFile";
		return 0;
	}
	unsigned int resp=SaveBuffer(buf,sz);
	if(resp==0) {
		std::cout << "*** WARNING SaveBuffer didn't write any data (possibly due to overflow or other error)" << std::endl;
		fwrite(buf,1,sz,f);
	}	else {
		unsigned int wrote=fwrite(buf,1,resp,f);
		if(wrote!=resp)
			std::cout << "*** WARNING short write (wrote " << wrote << ", expected " << resp << ")" << std::endl;
	}
	delete [] buf;
	return resp;
}

/*! @file
 * @brief Implements LoadSave, inherit from this to use a standard interface for loading and saving
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_3 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/01/09 02:02:59 $
 */

