#include <Shared/Config.h>
#include <stdio.h>
#include <string>
#include <ctype.h>

Config* config=NULL;

void Config::readConfig(const char* filename) {
  FILE* fp = fopen(filename, "r");
  char buf[80], key[30], value[50];
  section_t section=sec_invalid;
  if (fp==NULL) return; // ALTODO
  
  while (fscanf(fp,"%79[^\n]\n", buf)!=EOF) {
    if (sscanf(buf,"[%29[^]]",key)>0) {
      if (strncasecmp(key,"wireless",29)==0) {
        section=sec_wireless;
      } else if (strncasecmp(key,"vision",29)==0) {
        section=sec_vision;
      } else if (strncasecmp(key,"main",29)==0) {
        section=sec_main;
      } else if (strncasecmp(key,"behaviors",29)==0) {
        section=sec_behaviors;
      } else if (strncasecmp(key,"controller",29)==0) {
        section=sec_controller;
      } else if (strncasecmp(key,"motion",29)==0) {
        section=sec_motion;
      } else if (strncasecmp(key,"worldmodel2",29)==0) {
        section=sec_worldmodel2;
      } else if (strncasecmp(key,"sound",29)==0) {
        section=sec_sound;
      } else {
        section=sec_invalid;
      }
    } else if (sscanf(buf,"%29[^=]=%49s",key,value)>1) {
      switch (section) {
			case sec_wireless:
				if (strncasecmp(key,"id",29)==0) {
					wireless.id=atoi(value);
				}
				break;
			case sec_vision:
				if (strncasecmp(key,"white_balance",29)==0) {
					if (strncasecmp(value,"indoor",49)==0) {
						vision.white_balance=1;
					} else if (strncasecmp(value,"flourescent",49)==0) {
						vision.white_balance=3;
					} else if (strncasecmp(value,"outdoor",49)==0) {
						vision.white_balance=2;
					}
				} else if (strncasecmp(key,"gain",29)==0) {
					if (strncasecmp(value,"low",49)==0) {
						vision.gain=1;
					} else if (strncasecmp(value,"mid",49)==0) {
						vision.gain=2;
					} else if (strncasecmp(value,"high",49)==0) {
						vision.gain=3;
					}
				} else if (strncasecmp(key,"shutter_speed",29)==0) {
					if (strncasecmp(value,"slow",49)==0) {
						vision.shutter_speed=1;
					} else if (strncasecmp(value,"mid",49)==0) {
						vision.shutter_speed=2;
					} else if (strncasecmp(value,"fast",49)==0) {
						vision.shutter_speed=3;
					}
				} else if (strncasecmp(key,"resolution",29)==0) {
					if (strncasecmp(value,"full",49)==0) {
						vision.resolution=1;
					} else if (strncasecmp(value,"half",49)==0) {
						vision.resolution=2;
					} else if (strncasecmp(value,"quarter",49)==0) {
						vision.resolution=3;
					}
				} else if (strncasecmp(key,"thresh",29)==0) {
					strncpy(vision.thresh,value,49);
				} else if (strncasecmp(key,"colors",29)==0) {
					strncpy(vision.colors,value,49);
				} else if (strncasecmp(key,"raw_port",29)==0) {
					vision.raw_port=atoi(value);
				} else if (strncasecmp(key,"rle_port",29)==0) {
					vision.rle_port=atoi(value);
				} else if (strncasecmp(key,"obj_port",29)==0) {
					vision.obj_port=atoi(value);
				}
				break;
			case sec_main:
				if (strncasecmp(key,"console_port",29)==0) {
					main.console_port=atoi(value);
				} else if (strncasecmp(key,"stderr_port",29)==0) {
					main.stderr_port=atoi(value);
				} else if (strncasecmp(key,"error_level",29)==0) {
					main.error_level=atoi(value);
				} else if (strncasecmp(key,"debug_level",29)==0) {
					main.debug_level=atoi(value);
				} else if (strncasecmp(key,"verbose_level",29)==0) {
					main.verbose_level=atoi(value);
				} else if (strncasecmp(key,"wsjoints_port",29)==0) {
					main.wsjoints_port=atoi(value);
				} else if (strncasecmp(key,"wspids_port",29)==0) {
					main.wspids_port=atoi(value);
				} else if (strncasecmp(key,"mecha_port",29)==0) {
					main.mecha_port=atoi(value);
				} else if (strncasecmp(key,"aibo3d_port",29)==0) {
					main.aibo3d_port=atoi(value);
				} else if (strncasecmp(key,"use_VT100",29)==0) {
					main.use_VT100=extractBool(value);
				}
				break;
			case sec_behaviors:
				break;
			case sec_controller:
				if (strncasecmp(key,"gui_port",29)==0)
					controller.gui_port = atoi(value);
				else if (strncasecmp(key,"select_snd",29)==0)
					strncpy(controller.select_snd,value,49);
				else if (strncasecmp(key,"next_snd",29)==0)
					strncpy(controller.next_snd,value,49);
				else if (strncasecmp(key,"prev_snd",29)==0)
					strncpy(controller.prev_snd,value,49);
				else if (strncasecmp(key,"read_snd",29)==0)
					strncpy(controller.read_snd,value,49);
				else if (strncasecmp(key,"cancel_snd",29)==0)
					strncpy(controller.cancel_snd,value,49);
				break;
			case sec_motion:
				if (strncasecmp(key,"root",29)==0)
					motion.root=value;
				else if (strncasecmp(key,"estop_on_snd",29)==0)
					strncpy(motion.estop_on_snd,value,49);
				else if (strncasecmp(key,"estop_off_snd",29)==0)
					strncpy(motion.estop_off_snd,value,49);
				break;
			case sec_worldmodel2:
				if (strncasecmp(key,"dm_port",29)==0)
					worldmodel2.dm_port = atoi(value);
				else if (strncasecmp(key,"hm_port",29)==0)
					worldmodel2.hm_port = atoi(value);
				else if (strncasecmp(key,"gm_port",29)==0)
					worldmodel2.gm_port = atoi(value);
				else if (strncasecmp(key,"fs_port",29)==0)
					worldmodel2.fs_port = atoi(value);
				break;
			case sec_sound:
				if (strncasecmp(key,"root",29)==0)
					sound.root=value;
				else if (strncasecmp(key,"sample_rate",29)==0)
					sound.sample_rate = atoi(value);
				else if (strncasecmp(key,"sample_bits",29)==0)
					sound.sample_bits = atoi(value);
				else if (strncasecmp(key,"preload",29)==0)
					sound.preload.push_back(value);
				break;
			default:
				break;
      }
    }
  }
  fclose(fp);
}

bool Config::extractBool(const char * value) {
	int i=0;
	while(isspace(value[i])) i++;
	if(strncasecmp(&value[i],"t",29)==0)
		return true;
	else if(strncasecmp(&value[i],"f",29)==0)
		return false;
	else if(strncasecmp(&value[i],"true",29)==0)
		return true;
	else if(strncasecmp(&value[i],"false",29)==0)
		return false;
	else if(strncasecmp(&value[i],"y",29)==0)
		return true;
	else if(strncasecmp(&value[i],"n",29)==0)
		return false;
	else if(strncasecmp(&value[i],"yes",29)==0)
		return true;
	else if(strncasecmp(&value[i],"no",29)==0)
		return false;
	else
		return atoi(value);
}

/*! @file
 * @brief Implements Config, which provides global access to system configuration information
 * @author alokl (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_3 $
 * $Revision: 1.12 $
 * $State: Exp $
 * $Date: 2003/06/12 23:41:40 $
 */

