#include "EmergencyStopMC.h"
#include "Shared/WorldState.h"
#include "Shared/get_time.h"
#include "Motion/MotionManager.h"
#include "SoundPlay/SoundManager.h"
#include "Shared/Config.h"
#include "Events/EventRouter.h"
#include "Shared/ERS210Info.h"
#include "Shared/ERS220Info.h"

EmergencyStopMC::EmergencyStopMC()
	: PostureMC(), paused(false), stilldown(false), active(true), period(2000),
		timeoflastbtn(0), timeofthisbtn(0), timeoflastfreeze(0), duration(600),
		pidcutoff(static_cast<unsigned char>(0.16*255)), ledengine()
{
	setAutoPrune(false);
	for(unsigned int i=0; i<NumPIDJoints; i++)
		piddutyavgs[i]=0;
	if(state->robotDesign&WorldState::ERS210Mask) {
		ledengine.cycle(ERS210Info::TlRedLEDMask,period,1,0,period/2);
		ledengine.cycle(ERS210Info::TlBluLEDMask,period,1);
	} else if(state->robotDesign&WorldState::ERS220Mask) {
		ledengine.cycle(ERS220Info::TailCenterLEDMask, period, 2.0f, -.5f, (int)(period * 0/5.5));
		ledengine.cycle(ERS220Info::TailLeftLEDMask|ERS220Info::TailRightLEDMask,   period, 2.0f, -.5f, (int)(period * 1/5.5));
		ledengine.cycle(ERS220Info::BackLeft3LEDMask|ERS220Info::BackRight1LEDMask, period, 2.0f, -.5f, (int)(period * 2/5.5));
		ledengine.cycle(ERS220Info::BackLeft2LEDMask|ERS220Info::BackRight2LEDMask, period, 2.0f, -.5f, (int)(period * 3/5.5));
		ledengine.cycle(ERS220Info::BackLeft1LEDMask|ERS220Info::BackRight3LEDMask, period, 2.0f, -.5f, (int)(period * 4/5.5));
	}
}


int EmergencyStopMC::updateOutputs() {
	if(state->button_times[BackButOffset]) {
		if(!stilldown) {
			stilldown=true;
			timeoflastbtn=timeofthisbtn;
			timeofthisbtn=get_time();
			//			cout << "Press " << timeofthisbtn << ' ' << timeoflastbtn << endl;
		}
		//		cout << "Down" << endl;
	} else if(stilldown) {
		//		cout << "Release " << get_time() << endl;
		stilldown=false;
		if((get_time()-timeoflastbtn)<duration)
			setStopped(!paused);
	}
	if(paused) {
		for(unsigned int i=0; i<NumPIDJoints; i++) {
			piddutyavgs[i]=static_cast<unsigned char>(piddutyavgs[i]*.8+fabs(state->pidduties[i])*255*.2);
			if(piddutyavgs[i]>pidcutoff) {
				cmds[i].value-=state->pidduties[i]/10;
				//				cmds[i].value=state->outputs[i];
				//				cout << outputNames[i] << ' ' << state->pidduties[i] << ' ' << state->outputs[i] << endl;
			}
		}
	}
	ledengine.updateLEDs(&cmds[LEDOffset]);
	return PostureMC::updateOutputs();
}

void EmergencyStopMC::takeSnapshot() {
	for(unsigned int i=0; i<NumOutputs; i++)
		cmds[i].value=state->outputs[i];
	dirty=true;
}

void EmergencyStopMC::setActive(bool a) {
	if(paused) {
		if(!a && active)
			releaseJoints();
		else if(a && !active)
			freezeJoints();
	}
	active=a;
}


void EmergencyStopMC::setStopped(bool p, bool sound) {
	if(p!=paused) {
		paused=p;
		if(active) {
			dirty=true;
			if(paused) {
				freezeJoints();
				if(sound)
					sndman->PlayFile(config->motion.estop_on_snd);
				timeoflastfreeze=get_time();
				//			pprintf(TextOutputStream,"*** PAUSED ***\n");
				cout << "*** PAUSED ***" << endl;
			} else {
				releaseJoints();
				if(sound)
					sndman->PlayFile(config->motion.estop_off_snd);
				//			pprintf(TextOutputStream,"*** UNPAUSED ***\n");
				cout << "*** UNPAUSED ***" << endl;
			}
		}
	}
}

void EmergencyStopMC::freezeJoints() {
	takeSnapshot();
	for(unsigned int i=0; i<LEDOffset; i++)
		cmds[i].weight=1;
	for(unsigned int i=LEDOffset; i<LEDOffset+NumLEDs; i++)
		cmds[i].unset(); // let other commands' LEDs "show through"
	for(unsigned int i=LEDOffset+NumLEDs; i<NumOutputs; i++)
		cmds[i].weight=1;
	if(state->robotDesign&WorldState::ERS210Mask) {
		cmds[ERS210Info::TlRedLEDOffset].set(0,.5);
		cmds[ERS210Info::TlBluLEDOffset].set(0,.5);
	} else if(state->robotDesign&WorldState::ERS220Mask) {
		for(unsigned int i = 0; i < NumLEDs; i++)
			if((ERS220Info::TailLEDMask|ERS220Info::BackLEDMask) & (1 << i))
				cmds[LEDOffset + i].set(0, .5);
	}
	postEvent(EventBase(EventBase::estopEGID,getID(),EventBase::activateETID,0));
}

void EmergencyStopMC::releaseJoints() {
	for(unsigned int i=0; i<NumOutputs; i++)
		cmds[i].unset();
	//these lines prevent residual display
	if(state->robotDesign&WorldState::ERS210Mask) {
		motman->setOutput(this,ERS210Info::TlRedLEDOffset,0.f);
		motman->setOutput(this,ERS210Info::TlBluLEDOffset,0.f);
	} else if(state->robotDesign&WorldState::ERS220Mask) {
		for(unsigned int i = 0; i < NumLEDs; i++)
			if((ERS220Info::TailLEDMask|ERS220Info::BackLEDMask) & (1 << i))
				motman->setOutput(this,LEDOffset + i,0.f);
	}
	postEvent(EventBase(EventBase::estopEGID,getID(),EventBase::deactivateETID,get_time()-timeoflastfreeze));
}

/*! @file
 * @brief Implements EmergencyStopMC, overrides all joints, allows modelling, blinks tail
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_3 $
 * $Revision: 1.13 $
 * $State: Exp $
 * $Date: 2003/06/10 18:30:00 $
 */

