//-*-c++-*-
#ifndef INCLUDED_MechaControllerBehavior_h_
#define INCLUDED_MechaControllerBehavior_h_

#include <iostream>
#include "Wireless/Wireless.h"
#include "Behaviors/BehaviorBase.h"
#include "Motion/MotionManager.h"
#include "Motion/WalkMC.h"
#include "Motion/HeadPointerMC.h"
#include "Events/EventRouter.h"
#include "Events/EventBase.h"
#include "SoundPlay/SoundManager.h"
#include "Shared/Config.h"

//! Listens to mecha control commands coming in from the command port for remotely controlling the walk
class MechaControllerBehavior : public BehaviorBase {

 public:	
	//! Points to the one MechaControllerBehavior object that the input
	//! command stream is talking to. A kludge. Dunno how you're gonna
	//! make sure you're not using this uninitialized.
	static MechaControllerBehavior * theOneMCB;
	static int mechacmd_callback(char *buf, int bytes); //!< called by wireless when there's new data

 protected:
	MotionManager::MC_ID walker_id; //!< the WalkMC to use
	MotionManager::MC_ID head_id;   //!< the HeadPointerMC to use
 
 private:
	//!@name Command Bytes
	static const char CMD_fwd  = 'f'; //!< handy symbol for matching incoming communication
	static const char CMD_roto = 'r';
	static const char CMD_side = 's';
	static const char CMD_opt0 = '0';
	static const char CMD_opt1 = '1';
	static const char CMD_opt2 = '2';
	static const char CMD_opt3 = '3';
	static const char CMD_opt4 = '4';
	static const char CMD_opt5 = '5';
	static const char CMD_opt6 = '6';
	static const char CMD_opt7 = '7';
	static const char CMD_opt8 = '8';
	static const char CMD_opt9 = '9';
	//@}

	float dx; //!< Motion parameter
	float dy; //!< Motion parameter
	float da; //!< Motion parameter

	//! The last MCB object that was theOneMCB, so we can restore it
	//! to prominence when we die. This is a nice gesture, but it doesn't
	//! really make sense since we're all using the same port. But just
	//! in case something changes and we don't do that, this mechanism
	//! is in place.
	MechaControllerBehavior *theLastOneMCB;

	//! The input command stream socket
	Socket *cmdsock;

	//! Executes a command. Called by mechacmd_callback.
	void runCommand(unsigned char *command);

	MechaControllerBehavior(const MechaControllerBehavior&); //!< don't call
	MechaControllerBehavior operator=(const MechaControllerBehavior&); //!< don't call

 public:
	//! constructor
	MechaControllerBehavior() :
	  BehaviorBase(),
	  walker_id(MotionManager::invalid_MC_ID),
	  head_id(MotionManager::invalid_MC_ID),
	  dx(0), dy(0), da(0),
	  theLastOneMCB(theOneMCB),
	  cmdsock(wireless->socket(SocketNS::SOCK_STREAM, 2048, 2048))
	{ theOneMCB = this; }
	//! destructor
	virtual ~MechaControllerBehavior() { theOneMCB = theLastOneMCB; }

	virtual void DoStart();

	virtual void DoStop();

	//! The only event we could possibly receive is the stop-if-no-heartbeat timer.
	virtual void processEvent(const EventBase &) {
		WalkMC *walker = (WalkMC*)motman->checkoutMotion(walker_id);
		walker->setTargetVelocity(0,0,0);
		motman->checkinMotion(walker_id);
	}

	virtual std::string getName() const { return "MechaController"; }
	static std::string getClassDescription() { return "Listens to mecha control commands coming in from the command port."; }
};

/*! @file
 * @brief Describes MechaControllerBehavior, listens to mecha control commands coming in from the command port for remotely controlling the walk
 * @author tss (Creator)
 * 
 * $Author: ejt $
 * $Name: tekkotsu-1_3 $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2003/06/12 23:41:40 $
 */

#endif 
