//-*-c++-*-
#ifndef INCLUDED_DumbWM2Behavior_h_
#define INCLUDED_DumbWM2Behavior_h_

#include "Behaviors/BehaviorBase.h"
#include "WorldModel2/WorldModel2.h"

//! Simply turns on a WM2 object. Useful for running concurrently with other behaviors and seeing what shows up in the world model.
class DumbWM2Behavior : public BehaviorBase {
 public:
	//! constructor
	DumbWM2Behavior() : BehaviorBase(), WM2()
	{ }
	//! destructor
	virtual ~DumbWM2Behavior() {
	}

	virtual void DoStart() {
		BehaviorBase::DoStart();
		WM2.enableIR();
	}

	virtual void DoStop() {
		BehaviorBase::DoStop();
		WM2.disableIR();
	}

	//! doesn't do anything
	virtual void processEvent(const EventBase &) { }

	virtual std::string getName() const { return "DumbWM2Behavior"; }
	static std::string getClassDescription() { return "Creates a WM2 object.  Useful for running concurrently with other behaviors and seeing what shows up in the world model."; }

 protected:
	WorldModel2 WM2; //!< the world model this is associated with
};

/*! @file
 * @brief Describes DumbWM2Behavior - Simply turns on a WM2 object. Useful for running concurrently with other behaviors and seeing what shows up in the world model.
 * @author tss (Creator)
 * 
 * $Author: ejt $
 * $Name: tekkotsu-1_3 $
 * $Revision: 1.7 $
 * $State: Exp $
 * $Date: 2003/06/12 23:41:39 $
 */

#endif 
