//-*-c++-*-
#ifndef INCLUDED_ToggleHeadLightControl_h_
#define INCLUDED_ToggleHeadLightControl_h_

#include "NullControl.h"
#include "Shared/SharedObject.h"
#include "Motion/PostureMC.h"
#include "Shared/ERS220Info.h"

//! opens or closes the head light on an ERS-220
class ToggleHeadLightControl : public NullControl {
public:
	//! constructor
	ToggleHeadLightControl() : NullControl("ToggleHeadLightControl","Opens or closes the head light on an ERS-220") {}

	//! opens/closes the head light
	virtual ControlBase * activate(MotionCommand::MC_ID disp_id, Socket * gui) {
		if(state->robotDesign & WorldState::ERS220Mask) {
			unsigned int light=ERS220Info::RetractableHeadLEDOffset;
			SharedObject<PostureMC> pose;
			pose->setOutputCmd(light,!state->outputs[light]);
			motman->addMotion(pose,true);
		}
		return NullControl::activate(disp_id,gui);
	}
};

/*! @file
 * @brief Defines ToggleHeadLightControl, which will open or close the head light on an ERS-220
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_3 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2003/06/13 05:50:16 $
 */

#endif
