//-*-c++-*-
#ifndef INCLUDED_SavePostureControl_h_
#define INCLUDED_SavePostureControl_h_

#include "StringInputControl.h"
#include "Motion/PostureEngine.h"

//! Upon activation, saves the current position to a file name read from user (stored in /ms/data/motion/...)
class SavePostureControl : public StringInputControl {
 public:
	//! Constructor
	SavePostureControl() : StringInputControl("Save Posture","Saves current posture to filename read from user","Please enter name for posture file (in /ms/data/motion)...") {}
	//! Constructor
	SavePostureControl(const std::string& n) : StringInputControl(n,"Saves current posture to filename read from user","Please enter name for posture file (in /ms/data/motion)...") {}

	virtual ControlBase * takeInput(const std::string& msg) {
		std::string filename;
		if(msg[0]=='/')
			filename=msg;
		else
			filename="/ms/data/motion/"+msg;
		PostureEngine post;
		post.takeSnapshot();
		post.SaveFile(filename.c_str());
		return StringInputControl::takeInput(msg);
	}
};

/*! @file
 * @brief Defines SavePostureControl, which when activated, saves the current position to a file name read from user (stored in /ms/data/motion/...)
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_3 $
 * $Revision: 1.6 $
 * $State: Exp $
 * $Date: 2003/06/12 18:06:10 $
 */

#endif
