//-*-c++-*-
#ifndef INCLUDED_RunSequenceControl_h_
#define INCLUDED_RunSequenceControl_h_

#include "FileBrowserControl.h"
#include "Motion/MotionSequenceMC.h"
#include "Shared/TimeET.h"
#include "Shared/Config.h"
#include <string>

//! Upon activation, loads a position from a file name read from cin (stored in ms/data/motion...)
/*! The template parameter is passed to MotionSequenceMC's template parameter in order
 *  to specify the number of keyframes to reserve - larger values use more memory, but will allow
 *  you to load more complicated sequences.
 */
template<unsigned int SequenceSize>
class RunSequenceControl : public FileBrowserControl, public EventListener {
public:
	//! Constructor, sets filter to *.mot
	RunSequenceControl(const std::string& n, MotionManager::MC_ID estop_id)
		: FileBrowserControl(n,"Runs a motion sequence from a user-specified file",config->motion.root), estopid(estop_id)
	{
		setFilter("*.mot");
	}

	//! this is to help reduce the twitch at the end (estop tries to go back to its position when this is removed)
	virtual void processEvent(const EventBase& event) {
		erouter->removeListener(this,event);
		MMAccessor<EmergencyStopMC> estop(estopid);
		estop->takeSnapshot();
		estop->setActive(true);
	}

protected:
	//!does the actual loading of the MotionSequence
	virtual ControlBase* selectedFile(const std::string& f) {
		TimeET timer;
		SharedObject< MotionSequenceMC<SequenceSize> > s(f.c_str());
		cout << "Load Time: " << timer.Age() << endl;
		MMAccessor<EmergencyStopMC>(estopid)->setActive(false);
		MotionManager::MC_ID id=motman->addMotion(s,MotionManager::kEmergencyPriority+1,true);
		erouter->addListener(this,EventBase::motmanEGID,id,EventBase::deactivateETID);
		return this;
	}

	MotionManager::MC_ID estopid; //!< MC_ID of the emergency stop (so we can reset it to the end frame)
};

/*! @file
 * @brief Defines RunSequenceControl, which when activated, loads and runs a motion sequence from a file name read from cin (stored in ms/data/motion)
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_3 $
 * $Revision: 1.9 $
 * $State: Exp $
 * $Date: 2003/06/12 18:06:10 $
 */

#endif
