//-*-c++-*-
#ifndef INCLUDED_ProfilerCheckControl_h_
#define INCLUDED_ProfilerCheckControl_h_

#include "ControlBase.h"
#include "Shared/WorldState.h"

//! causes the WorldState::mainProfile and WorldState::motionProfile to display reports to cout
class ProfilerCheckControl : public ControlBase {
public:
	//! Constructor
	ProfilerCheckControl() : ControlBase("Profiler Check","Reports time spent in all of the profiled sections in all processes") {}

	//! Destructor
	~ProfilerCheckControl() {}
	
	//! Prints a report to cout
	virtual ControlBase * activate(MotionManager::MC_ID display, Socket *) {
		if(display!=MotionManager::invalid_MC_ID) {
			//!@todo make the leds flash
		}
		printf("~~~ Main: ~~~\n%s",state->mainProfile.report().c_str());
		printf("~~~ Motion: ~~~\n%s",state->motionProfile.report().c_str());
		return NULL;
	}
};

/*! @file
 * @brief Defines ProfilerCheckControl, which causes the WorldState::mainProfile and WorldState::motionProfile to display reports to cout
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_3 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2003/06/10 00:53:48 $
 */

#endif
