// Sends "Mecha" command data from TekkotsuMon to the AIBO.
import java.lang.Integer;
import java.lang.String;
import java.lang.System;
import java.io.OutputStream;
import java.net.Socket;

// The class itself. Brilliant that even though it does the talking,
// it extends TCP*Listener*. Note: TCPListener has not been modified
// to send data--that's been taken care of here. Later we need a
// centralized means of converting and sending data.
public class MechaController extends TCPListener {
  // The command output stream
  OutputStream out;
  Socket mysock;

  // Connect to control socket
  void connected(Socket socket) {
    mysock = socket;
    try {
      out = mysock.getOutputStream();
    } catch(Exception e) { return; }

    _isConnected = true;
    // Nothing else to do here
  }

  // Disconnect from control socket
  public void close() {
    try { mysock.close(); } catch(Exception e) {}
    _isConnected = false;
    super.close();
  }

  // Send a mecha command
  public void sendCommand(String command, double param) {
    // Extract command byte
    byte cmdbytes[] = command.getBytes();

    // Construct the command sequence
    byte sequence[] = new byte[5];
    // The commmand byte is the first byte in cmdbytes. The remaining
    // four bytes belong to the parameter. We have to convert the parameter
    // (which we send as a float, not a double) to MIPS byte order thanks to
    // (ahem) prior design decisions.
    sequence[0] = cmdbytes[0];
    int pbits = Float.floatToIntBits((float) param);
    Integer i;
    i = new Integer((pbits >> 24) & 0xff); sequence[4] = i.byteValue();
    i = new Integer((pbits >> 16) & 0xff); sequence[3] = i.byteValue();
    i = new Integer((pbits >>  8) & 0xff); sequence[2] = i.byteValue();
    i = new Integer(pbits & 0xff);	   sequence[1] = i.byteValue();
    // Now write the whole command.
    try {
      out.write(sequence, 0, 5);
    } catch(Exception e) { close(); return; }
  }

  // Some state inquiry functions
  public boolean hasData() { return false; }
  public boolean isConnected() { return _isConnected; }

  // Constructors
  public MechaController() { super(); }
  public MechaController(int port) { super(port); }
  public MechaController(String host, int port) { super(host, port); }
}
