import java.net.ServerSocket;
import java.net.Socket;
import java.io.InputStream;
import java.io.IOException;

public abstract class Listener implements Runnable {
  public Listener() { _port=-1; _isConnected=false; }
  public Listener(int port) { this(); setPort(port); }
  public Listener(String host, int port) { this(); setHostPort(host, port); }

  public void setPort(int port) {
    _isServer=true;
    _port=port;
    startThread();
  }

  public void setHostPort(String host, int port) {
    _isServer=false;
    _host=host;
    _port=port;
    startThread();
  }
  
  public void startThread() {
    _listenerThread=new Thread(this);
    _listenerThread.start();
  }

  public void run() {
    if (_port >= 0) {
      if (_isServer)
        runServer();
      else
        runConnect();
    } else {
      System.out.println("can't start Listener without [host],port");
    }
  }

  void frameTimer() {
    _frametimer_numframes++;
    if (System.currentTimeMillis()-_frametimer_timer>1000) {
      System.out.println("updated at "+_frametimer_numframes+"hz");
      _frametimer_numframes=0;
      _frametimer_timer=System.currentTimeMillis();
    }
  }

  double readDouble(InputStream in) throws IOException {
    return Double.longBitsToDouble(readLong(in));
  }

  long readLong(InputStream in) throws IOException {
    int read=0;
    byte[] buf=new byte[8];
    while (read<8) { read=read+in.read(buf,read,8-read); }
    return (b2l(buf[7])<<56) | (b2l(buf[6])<<48) |
           (b2l(buf[5])<<40) | (b2l(buf[4])<<32) |
           (b2l(buf[3])<<24) | (b2l(buf[2])<<16) |
           (b2l(buf[1])<< 8) | b2l(buf[0]);
  }

  float readFloat(InputStream in) throws IOException {
    return Float.intBitsToFloat(readInt(in));
  }

  int readInt(InputStream in) throws IOException {
    int read=0;
    byte[] buf=new byte[4];
    while (read<4) { read=read+in.read(buf,read,4-read); }
    return (b2i(buf[3])<<24) | (b2i(buf[2])<<16) |
           (b2i(buf[1])<< 8) | b2i(buf[0]);
  }

  void readBytes(byte[] buf, InputStream in, int bytes) throws IOException {
    int read=0;
    while (read<bytes) { read=read+in.read(buf, read, bytes-read); }
  }

  int b2i(byte b) { return (b>=0)?(int)b:((int)b)+256; }
  long b2l(byte b) { return (b>=0)?(long)b:((long)b)+256; }

  abstract void runServer();
  abstract void runConnect();
  abstract public void close();

  boolean _isServer;
  int _port;
  String _host;
  boolean _isConnected;
  volatile Thread _listenerThread;

  int _frametimer_numframes=0;
  long _frametimer_timer=System.currentTimeMillis();
}
