#include "StartupBehavior.h"

#include "Behaviors/Controller.h"
#include "Shared/SharedObject.h"

#include "Behaviors/Controls/BatteryCheckControl.h"
#include "Behaviors/Controls/BehaviorActivatorControl.h"
#include "Behaviors/Controls/BehaviorSwitchControl.h"
#include "Behaviors/Controls/FileBrowserControl.h"
#include "Behaviors/Controls/LoadPostureControl.h"
#include "Behaviors/Controls/LoadWalkControl.h"
#include "Behaviors/Controls/MenuControl.h"
#include "Behaviors/Controls/MCValueEditControl.h"
#include "Behaviors/Controls/PlaySoundControl.h"
#include "Behaviors/Controls/ProfilerCheckControl.h"
#include "Behaviors/Controls/RunSequenceControl.h"
#include "Behaviors/Controls/SavePostureControl.h"
#include "Behaviors/Controls/SaveWalkControl.h"
#include "Behaviors/Controls/ValueEditControl.h"
#include "Behaviors/Controls/ValueSetControl.h"

#include "Behaviors/Controls/EventLogger.h"

#include "Behaviors/Demos/AutoGetupBehavior.h"
#include "Behaviors/Demos/BatteryMonitorBehavior.h"
#include "Behaviors/Demos/ChaseBallBehavior.h"
#include "Behaviors/Demos/StareAtBallBehavior.h"
#include "Behaviors/Demos/FollowHeadBehavior.h"
#include "Behaviors/Demos/HeadLevelBehavior.h"
#include "Behaviors/Demos/EvtRptBehavior.h"

#include "Behaviors/Demos/PaceTargetsMachine.h"
#include "Behaviors/Demos/WalkToTargetMachine.h"
#include "Behaviors/Demos/BanditMachine.h"
#include "Behaviors/Demos/WorldModel2Behavior.h"
#include "Behaviors/Demos/DumbWM2Behavior.h"
#include "Behaviors/Demos/SoundTestBehavior.h"
#include "Behaviors/Demos/MechaControllerBehavior.h"

#include "Motion/MotionCommand.h"
#include "Motion/PostureMC.h"
#include "Motion/EmergencyStopMC.h"
#include "Motion/PIDMC.h"
#include "Motion/MotionSequenceMC.h"
#include "Motion/MMAccessor.h"

#include "SoundPlay/SoundManager.h"

StartupBehavior gStartup; //!< used to initialize the global ::startupBehavior, used by MMCombo
BehaviorBase& startupBehavior=gStartup; //!< used by MMCombo as the init behavior

StartupBehavior::StartupBehavior()
	: BehaviorBase(), spawned(),
		stop_id(MotionManager::invalid_MC_ID),
		pid_id(MotionManager::invalid_MC_ID)
{
	AddReference(); // this is a global, so there's a global reference
}

StartupBehavior::~StartupBehavior() {}

void StartupBehavior::DoStart() {
	BehaviorBase::DoStart();
	
	//This will "fade" in the PIDs so the joints don't jerk to full power, also looks cooler
	pid_id=motman->addMotion(SharedObject<PIDMC>(0),MotionManager::kEmergencyPriority+1,false);
	//also, pause before we start fading in, PIDs take effect right away, before the emergencystop is picked up
	erouter->addTimer(this,0,4*FrameTime*NumFrames,true);

	//This is the default emergency stop
	const SharedObject<EmergencyStopMC> stop;
	stop->LoadFile("/ms/data/motion/liedown.pos"); //This *should* be replaced by the current position, but just in case, better than setting everything to 0's
	stop->setStopped(true); //if you want to start off paused
	sndman->StopPlay(); //so it doesn't play the halt sound the first time
	stop_id=motman->addMotion(stop,MotionManager::kEmergencyPriority);
	
	//This displays the current battery conditions
	BatteryCheckControl batchk;
	batchk.activate(MotionManager::invalid_MC_ID);
	//	const SharedObject<LedMC> led; //! @todo LedMC's don't support autopruning yet, it should for uses like this, or could the one in Controller
	//	batchk.activate(motman->addMotion(led,true));
	batchk.deactivate();

	//This is for the menu system
	Controller * controller=new Controller;
	controller->DoStart();
	SetupController(*controller);
	controller->setEStopID(stop_id);
	spawned.push_back(controller);
	
	sndman->PlayFile("roar.wav");
	
	//This will close the mouth so it doesn't look stupid
	//Now done by setting the emergency stop directly in processEvent, but left as demo code:
	/*	const SharedObject<PostureMC> closemouth;
			closemouth->setJointCmd(MouthOffset,outputRanges[MouthOffset][MaxRange],1);
			motman->addMotion(closemouth,MotionCommand::kEmergencyPriority+2,true);
	*/
}

void StartupBehavior::DoStop() {
	for(std::vector<BehaviorBase*>::iterator it=spawned.begin(); it!=spawned.end(); it++)
		(*it)->DoStop();
	BehaviorBase::DoStop();
}

/*!Uses a few timer events at the beginning to fade in the PID values, and closes the mouth too*/
void StartupBehavior::processEvent(const EventBase&) {
	static unsigned int start_time=-1U;
	const unsigned int tot_time=2047; //if this is set to 2048, i sometimes get funny errors: [oid:80000034,prio:1] AGRMSDriver::SetGain() : 0x0A IS USED FOR GAIN SHIFT VALUE.
	if(start_time==-1U) { //first time
		start_time=get_time();
		MMAccessor<EmergencyStopMC>(stop_id)->takeSnapshot(); //take new snapshot with hopefully valid data
	} else {
		float power=(get_time()-start_time)/(float)tot_time;
		if(power>1)
			power=1;
		{ MMAccessor<PIDMC>(pid_id)->setAllPowerLevel(power); }
		{ MMAccessor<EmergencyStopMC>(stop_id)->setOutputCmd(MouthOffset,outputRanges[MouthOffset][MaxRange]); }
	}
	if((get_time()-start_time)>=tot_time) {
		erouter->removeTimer(this);
		motman->removeMotion(pid_id);
		pid_id=MotionManager::invalid_MC_ID;
	}
}

/*class WalkToPinkBallFactory : public Factory<WalkToTargetMachine> {
	public:
	static WalkToTargetMachine* construct() { return new WalkToTargetMachine(VisionEventNS::PinkBallSID); }
	};
*/

void
StartupBehavior::SetupController(Controller& controller) {
	std::cout << "CONTROLLER-INIT..." << std::flush;
	std::stack< MenuControl* > mcsetup;
	{
		mcsetup.push(new MenuControl("Root Control"));
		mcsetup.top()->pushSlot(new MenuControl("Mode Switch"));
		{ 
			mcsetup.push((MenuControl*)mcsetup.top()->getSlots().back());
			BehaviorSwitchControlBase::BehaviorGroup * bg = new BehaviorSwitchControlBase::BehaviorGroup();
			//put behaviors here
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<FollowHeadBehavior>("Follow Head",bg,false));
			//			mcsetup.top()->pushSlot(new BehaviorSwitchControl<CameraBehavior>("Camera",bg,false));
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<SoundTestBehavior>("SoundTestBehavior",bg,false));
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<ChaseBallBehavior>("ChaseBallBehavior",bg,false));
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<StareAtBallBehavior>("StareAtBallBehavior",bg,false));
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<PaceTargetsMachine>("PaceTargetsMachine",bg,false));
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<WalkToTargetMachine,Factory1Arg<WalkToTargetMachine,VisionEventNS::VisionSourceID_t,VisionEventNS::PinkBallSID> >("WalkToPinkBall",bg,false));
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<BanditMachine>("BanditMachine",bg,false));
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<WorldModel2Behavior>("WorldModel2Behavior",bg,false));
			mcsetup.pop();
		}
		mcsetup.top()->pushSlot(new MenuControl("Background Behaviors"));
		{ 
			mcsetup.push((MenuControl*)mcsetup.top()->getSlots().back());
			mcsetup.top()->pushSlot((new BehaviorSwitchControl<AutoGetupBehavior>("Auto Getup",false))->start());
			mcsetup.top()->pushSlot((new BehaviorSwitchControl<BatteryMonitorBehavior>("Battery Monitor",false))->start());
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<EvtRptBehavior>("EvtRptBehavior",false));
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<DumbWM2Behavior>("DumbWM2Behavior",false));
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<MechaControllerBehavior>("MechaController",false));
			
			HeadLevelBehavior* levelbeh=new HeadLevelBehavior();
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<HeadLevelBehavior>("Head Level",levelbeh,NULL));
			
			mcsetup.pop();
		}
		mcsetup.top()->pushSlot(new BatteryCheckControl());
		mcsetup.top()->pushSlot(new ProfilerCheckControl());
		mcsetup.top()->pushSlot(new EventLogger());
		
		mcsetup.top()->pushSlot(new LoadPostureControl("Load Posture",stop_id));
		mcsetup.top()->pushSlot(new SavePostureControl("Save Posture"));
		mcsetup.top()->pushSlot(new RunSequenceControl<500>("Run Motion Sequence",stop_id));
		mcsetup.top()->pushSlot(new PlaySoundControl("Play Sound"));
		mcsetup.top()->pushSlot(new FileBrowserControl("Files","/"));
	}
	if(mcsetup.size()!=1)
		cout << "*** WARNING *** menu setup stack more than one or empty" << endl;
	controller.setRoot(mcsetup.top());
	cout << "DONE" << endl;
}

			/*			XORBehavior* xorbeh=new XORBehavior(); //i make other controls which reference xorbeh below
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<XORBehavior>("AI Control",xorbeh,bg));
			{ // I don't necessarily like this method of adding sub menus to control behavior parameters, but you can do it quickly. (cleaner to subclass the behavior, have it add its own)
				mcsetup.push((MenuControl*)mcsetup.top()->getSlots().back());
				mcsetup.top()->pushSlot(new BehaviorActivatorControl("Toggle",(BehaviorSwitchControlBase*)mcsetup.top()));
				mcsetup.top()->pushSlot(new ValueSetControl<float>("Enable learning (0.035)",&xorbeh->getModel()->learn_rate,0.035));
				mcsetup.top()->pushSlot(new ValueSetControl<float>("Disable learning",&xorbeh->getModel()->learn_rate,0));
				mcsetup.top()->pushSlot(new LoadAIControl("Load AI",xorbeh->getModel()));
				mcsetup.top()->pushSlot(new SaveAIControl("Save AI",xorbeh->getModel()));
				mcsetup.pop();
			}
			*/
