/*
 * almUtility.h -- contains utility routines for the AIBO LocalMap system.
 *
 * Started on 12/16/2002 by tss
 */

#ifndef _ALM_UTILITY_H_
#define _ALM_UTILITY_H_

/* This routine takes a grid cell index in the spherical depth map and returns
 * the corresponding azimuth and altitude angles. */
void dm_index2angles(int index, double &azimuth, double &altitude);

/* This routine does the reverse of dm_index2angles.
 * Returns false if the inputs correspond to no index in the map */
bool angles2dm_index(double azimuth, double altitude, int &index);

/* This routine converts an index into the horizontal height map and returns
 * the corresponding X and Y locations relative to the AIBO neck tilt
 * pivot */
void hm_index2xy(int index, double &x, double &y);

/* This routine does the reverse of hm_index2xy.
 * Returns false if the inputs correspond to no index in the map */
bool xy2hm_index(double x, double y, int &index);

/* This routine converts an index into the global height map and returns
 * the corresponding allocentric X and Y locations. */
void gm_index2xy(int index, double &x, double &y);

/* This routine does the reverse of gm_index2xy.
 * Returns false if the inputs correspond to no index in the map */
bool xy2gm_index(double x, double y, int &index);

/* This routine takes a depth measurement and the pan/tilt angles of the
 * head and returns the 3D XYZ position of the measured point. The
 * XYZ coordinate system has its origin on the ground just beneath the
 * center of AIBO's tilt pivot point. The X axis points out in front of
 * the AIBO, the Y axis leftwards, and the Z axis straight up. */
void head_range2xyz(double depth, double pan, double tilt,
		    double &x, double &y, double &z);

/* This routine takes a location in the 3D XYZ coordinates mentioned 
 * in head_range2xyz and computes the range, azimuth, and altitude values
 * for the location from the center of the AIBO's tilt pivot point. */
void xyz2neck_range(double x, double y, double z,
		    double &depth, double &azimuth, double &altitude);

/* This routine does the reverse of xyz2neck_range. Not much more to say
 * about that */
void neck_range2xyz(double depth, double azimuth, double altitude,
		    double &x, double &y, double &z);
#endif
