
#ifndef Wireless_h_DEFINED
#define Wireless_h_DEFINED

#include <OPENR/OObject.h>
#include <OPENR/OSubject.h>
#include <OPENR/OObserver.h>
#include <ant.h>
//#include "MMCombo/def.h"
#include "Socket.h"

#define WIRELESS_MAX_SOCKETS 100
#define WIRELESS_DEF_RECV_SIZE 1024
#define WIRELESS_DEF_SEND_SIZE 1024

using namespace SocketNS;

//! Tekkotsu wireless class
/*!
 * For more information on using wireless, please read the following tutorials:
 * - <a href="../AiboMon.html">TekkotsuMon</a>
 * - <a href="../Wireless.html">TCP/IP</a>
 * - <a href="../RemoteProcess.html">Remote Processing OPENR</a>
 * Tekkotsu Wireless and Remote Processing OPENR provide different
 * interfaces to comparable wireless functionality.
 */

class Wireless {
public:
  //! constructor - only one wireless object is required per Aperios process. 
  /*! MMCombo already creates one. The (global) instance is called wireless,
   * and you can access it by including Wireless/Wireless.h (this file) in
   * your code
   */
  Wireless();
  ~Wireless(); //!< destructor
  
  //@{
  //! Creates a new socket
  /*! @return pointer to Socket object created
   * @param ttype selects between TCP and UDP */
  Socket* socket(TransportType_t ttype);
  /*!@param ttype selects between TCP and UDP
	 * @param recvsize size of input buffer
   * @param sendsize size of output buffer
   */
  Socket* socket(TransportType_t ttype, int recvsize, int sendsize);
  //@}

  //! The socket waits for incoming connections.
  /*! That is, it acts like a server. If a connection is established and
   * later broken, it resumes waiting for new connections.
   */
  int listen(int sock, int port);

  //! The socket tries to connect to a specific
  int connect(int sock, const char* ipaddr, int port);
	//! sets receiver callback for a socket
  void setReceiver(int sock, int (*rcvcbckfn) (char*, int) );
	//! closes a socket
  void close(int sock);

  //@{
  //! utility function that you can use if you're curious about the state of the socket.
  /*! You shouldn't need to use it, since asking sockets for write
   * and read buffers does the necessary sanity checks
   */
  bool isConnected(int sock) { return sockets[sock]->state
                                        ==CONNECTION_CONNECTED; }
  bool isReady(int sock) { return !sockets[sock]->tx; }
  bool hasData(int sock) { return !sockets[sock]->rx; }
  //@}

  //@{
  //! helper function for the function with the same name that takes a socket descriptor (int)
  void setReceiver(Socket &sobj, int (*rcvcbckfn) (char*, int) )
    { setReceiver(sobj.sock, rcvcbckfn); }
  void setReceiver(Socket *sobj, int (*rcvcbckfn) (char*, int) )
    { setReceiver(sobj->sock, rcvcbckfn); }
  int listen(Socket &sobj, int port) { return listen(sobj.sock, port); } 
  int listen(Socket *sobj, int port) { return listen(sobj->sock, port); } 
  int connect(Socket &sobj, const char* ipaddr, int port)
    { return connect (sobj.sock, ipaddr, port); }
  int connect(Socket *sobj, const char* ipaddr, int port)
    { return connect (sobj->sock, ipaddr, port); }
  void close(Socket &sobj) { close(sobj.sock); }
  void close(Socket *sobj) { close(sobj->sock); }
  //@}

  //! function for internal and Socket use. You should not call this
  //@{
  void receive(int sock, int (*rcvcbckfn) (char*, int) );
  void receive(int sock);
  //@}

  //! function called by the Socket objects to actually write
  //! data to the network. You should not call this.
  //@{
  void send(int sock);
  void blockingSend(int sock);
  //@}
  

  //! callback function for communicating
  //! with Aperios Networking Toolkit. You should not call this.
  //@{
  void ListenCont (void* msg);
  void BindCont   (void* msg);
  void ConnectCont(void* msg);
  void SendCont   (void* msg);
  void ReceiveCont(void* msg);
  void CloseCont  (void* msg);
  //@}

private:
	//@{
	//!private ALOKL_TODO
  antStackRef ipstackRef;
  OID myOID;
  Socket* sockets[WIRELESS_MAX_SOCKETS];
  int sock_num;
	//@}

private:
  Wireless(const Wireless&); //!< don't call
  Wireless& operator= (const Wireless&); //!< don't call
};

extern Wireless* wireless;

#endif // Wireless_h_DEFINED
