#include "Socket.h"
#include <stdio.h>
#include "Wireless.h"
#include "Shared/Config.h"

Socket* sout=NULL;
Socket* serr=NULL;

byte*
Socket::getWriteBuffer(int bytesreq)
{
  if (sendBufSize-writeSize>=bytesreq
      && state==CONNECTION_CONNECTED)
    return writeData+writeSize;
  else
    return NULL;
}

void
Socket::write(int size)
{
  writeSize+=size;
  flush();
}

int
Socket::read()
{
  return -1;
}

byte*
Socket::getReadBuffer()
{
	return NULL;
//  return readData+readSize;
}

void
Socket::init()
{
  sendSize=0;
  writeSize=0;
}

int
Socket::setFlushType(FlushType_t fType)
{
  if (state != CONNECTION_CLOSED) return -1;
  flType=fType;
  return 0;
}

void
Socket::flush()
{
  if (flType==FLUSH_NONBLOCKING) {
    if (!tx) {
      byte *tempData=sendData;
      int tempSize=sendSize;
      sendData=writeData;
      writeData=tempData;
      sendSize=writeSize;
      writeSize=tempSize;
      wireless->send(sock); 
    }
  } else {
    sendData=writeData;
    sendSize=writeSize;
    wireless->blockingSend(sock);
  }
}

int
Socket::pprintf(int vlevel, const char *fmt, ...)
{
  if (state!=CONNECTION_CONNECTED
      || vlevel>verbosity) return 0;
  if (sendBufSize-writeSize<256) {
    flush();
    if (sendBufSize-writeSize<256)
      return -1;
  }

  int ret;
  va_list al;
  va_start(al,fmt);
  ret=vsprintf((char *)(writeData+writeSize), fmt, al);
  va_end(al);
  writeSize+=ret;
  flush();
  return ret;
}

int
Socket::printf(const char *fmt, ...)
{
  if (state!=CONNECTION_CONNECTED) return 0;
  if (sendBufSize-writeSize<256) {
    flush();
    if (sendBufSize-writeSize<256)
      return -1;
  }

  int ret;
  va_list al;
  va_start(al,fmt);
  ret=vsprintf((char *)(writeData+writeSize), fmt, al);
  va_end(al);
  writeSize+=ret;
  flush();
  return ret;
}

int
Socket::write(byte *buf, int size)
{
  byte *destbuf=getWriteBuffer(size);
  if (destbuf==NULL) return -1;
  memcpy(destbuf, buf, size);
  write(size);
  return size;
}

int
Socket::read(byte *buf, int size)
{  
/*  if (size>=recvBufSize-recvPos) return -1;
  memcpy(buf,recvData+recvPos,size);*/
  return -1;
}
