//-*-c++-*-
#ifndef INCLUDED_RobotInfo_h
#define INCLUDED_RobotInfo_h

#if TGT_ERS220
#	include "ERS220Info.h"
#else //default case, ERS210
#	if TGT_ERS210==0
#		warning "TGT_<model> undefined - defaulting to ERS210"
#	endif
#	include "ERS210Info.h"
#endif //model selection

//! Contains information about the robot, such as number of joints, PID defaults, timing information, etc.
namespace RobotInfo {

#if TGT_ERS220
	using namespace ERS220Info;
#else //default case, ERS210
	using namespace ERS210Info;
#endif //model selection

}

using namespace RobotInfo;
	
/*! @file
 * @brief Checks the define's to load the appropriate header and namespace
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_2 $
 * $Revision: 1.11 $
 * $State: Exp $
 * $Date: 2003/04/27 23:57:43 $
 */

#endif
