#include "EventBase.h"
#include <stdio.h>

const char* const EventBase::EventGeneratorNames[numEGIDs] = {
	"UnknownGen",
	"Vision",
	"Button",
	"WorldModel",
	"AI",
	"Audio",
	"Sensor",
	"Power",
	"Timer",
	"StateMachine",
	"Locomotion",
	"TextMsg",
	"EStop",
	"MotionManager"
};


EventBase::EventBase()
	: LoadSave(), stim_id(), magnitude(0), timestamp(get_time()), nameisgen(true), genID(unknownEGID), typeID(statusETID), sourceID((unsigned int)-1), duration(0)
{
	genName();
}

EventBase::EventBase(EventGeneratorID_t gid, unsigned int sid, EventTypeID_t tid, unsigned int dur)
	: LoadSave(), stim_id(), magnitude(0), timestamp(get_time()), nameisgen(true), genID(gid), typeID(tid), sourceID(sid), duration(dur)
{
	genName();
	if(tid==deactivateETID)
		setMagnitude(0.0);
	else
		setMagnitude(1.0);
}

EventBase::EventBase(EventGeneratorID_t gid, unsigned int sid, EventTypeID_t tid, unsigned int dur, const std::string& n, float mag)
	: LoadSave(), stim_id(n), magnitude(mag), timestamp(get_time()), nameisgen(false), genID(gid), typeID(tid), sourceID(sid), duration(dur)
{
	
}


unsigned int
EventBase::getBinSize() const {
	unsigned int used=0;
	used+=creatorSize("EventBase");
	used+=stim_id.size()+stringpad;
	used+=sizeof(magnitude);
	used+=sizeof(timestamp);
	used+=sizeof(nameisgen);
	used+=sizeof(char);
	used+=sizeof(char);
	used+=sizeof(sourceID);
	used+=sizeof(duration);
	return used;
}

unsigned int
EventBase::LoadBuffer(const char buf[], unsigned int len) {
	unsigned int origlen=len;
	unsigned int used=0;
	if(0==(used=checkCreator("EventBase",buf,len,true))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(stim_id,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(magnitude,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(timestamp,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(nameisgen,buf,len))) return 0;
	len-=used; buf+=used;
	char tmp;
	if(0==(used=decode(tmp,buf,len))) return 0;
	genID=(EventGeneratorID_t)tmp;
	len-=used; buf+=used;
	if(0==(used=decode(tmp,buf,len))) return 0;
	typeID=(EventTypeID_t)tmp;
	len-=used; buf+=used;
	if(0==(used=decode(sourceID,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(duration,buf,len))) return 0;
	len-=used; buf+=used;
	return origlen-len;	
}

unsigned int
EventBase::SaveBuffer(char buf[], unsigned int len) const {
	unsigned int origlen=len;
	unsigned int used=0;
	if(0==(used=saveCreator("EventBase",buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(stim_id,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(magnitude,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(timestamp,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(nameisgen,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode((char)genID,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode((char)typeID,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(sourceID,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(duration,buf,len))) return 0;
	len-=used; buf+=used;
	return origlen-len;
}

void
EventBase::genName() {
	if(!nameisgen)
		return;
	if(genID<numEGIDs) {
		stim_id=std::string("Evt_");
		stim_id+=EventGeneratorNames[genID];
	} else {
		stim_id=std::string("Evt_InvalidGen");
		stim_id+=genID; 
	}
	stim_id+="::";
	char tmp[16];
	snprintf(tmp,16,"0x%x",sourceID);
	stim_id+=tmp;
	/*	switch(genID) {
	case unknownEGID:
		stim_id="Evt_UknownGen::"; break;
	case visionEGID:
		stim_id="Evt_Vision::"; break;
	case buttonEGID:
		stim_id="Evt_Button::"; break;
	case worldModelEGID:
		stim_id="Evt_WorldModel::"; break;
	case aiEGID:
		stim_id="Evt_AI::"; break;
	case audioEGID:
		stim_id="Evt_Audio::"; break;
	case sensorEGID:
		stim_id="Evt_Sensor::"; break;
	case powerEGID:
		stim_id="Evt_Power::"; break;
	case timerEGID:
		stim_id="Evt_Timer::"; break;
	case eventRouterEGID:
		stim_id="Evt_EventRouter::"; break;
	default:
		stim_id="Evt_InvalidGen"; stim_id+=genID; stim_id+="::"; break;
		}*/
	/*	stim_id+=sourceID;*/
	// don't want to do this because it will cause AI to see them as separate stimuli
	/*stim_id+="::";
		switch(typeID) {
		case activateETID:
		stim_id+="act"; break;
		case statusETID:
		stim_id+="stat"; break;
		case deactivateETID:
		stim_id+="deact"; break;
		default:
		stim_id+="inv"; break;
		}*/
}

/*! @file
 * @brief Implements EventBase, the basic class for sending events around the system
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_2 $
 * $Revision: 1.10 $
 * $State: Exp $
 * $Date: 2003/04/25 18:22:39 $
 */

