//-*-c++-*-
#ifndef INCLUDED_VisualTargetCloseTrans_h_
#define INCLUDED_VisualTargetCloseTrans_h_

#include "Events/EventRouter.h"
#include "Events/VisionEvent.h"
#include "Shared/debuget.h"

//! causes a transition when a visual object is "close"
class VisualTargetCloseTrans : public Transition, public EventListener {
public:
	//!constructor
	explicit VisualTargetCloseTrans(StateNode* source, StateNode* destination, VisionEventNS::VisionSourceID_t source_id) : Transition(source,destination), EventListener(), sid(source_id) {}

	//!starts listening for the object specified by the source id in the constructor
	virtual void enable() { erouter->addListener(this,EventBase::visionEGID,sid); }

	//!called by StateNode when it becomes inactive - undo whatever you did in Enable()
	virtual void disable() { erouter->forgetListener(this); }

	//!if the object is "close", calls activate()
	virtual void processEvent(const EventBase& e) {
		const VisionEvent* ve=dynamic_cast<const VisionEvent*>(&e);
		ASSERTRET(ve!=NULL,"Casting error");
		//!@todo need to activate if it's "close"
	}
protected:
	//!Source ID of object to track
	VisionEventNS::VisionSourceID_t sid;
};

/*! @file
 * @brief Defines VisualTargetCloseTrans, which causes a transition when a visual object is "close"
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_2 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2003/03/01 20:53:32 $
 */

#endif
