//-*-c++-*-
#ifndef INCLUDED_Transition_h_
#define INCLUDED_Transition_h_

class StateNode;

//! Represents a transition between StateNodes.
/*! This is an abstract class - you'll want to subclass it to put
 *  conditions on the transitions */
class Transition {
public:
	//!constructor, specifies source and destination StateNode's
	Transition(StateNode* source, StateNode* destination) : src(source), dst(destination) {}
	//!copy constructor, just in case you need it
	Transition(const Transition& t) : src(t.src), dst(t.dst) {}
	//!destructor
	virtual ~Transition() {}

	//!called by StateNode when it becomes active - use this to request events (or whatever you need to do)
	virtual void enable()=0;
	//!called by StateNode when it becomes inactive - undo whatever you did in Enable()
	virtual void disable()=0;

	//!call this when the transition should be made, base class version simply calls StateNode::Leave() on #src and StateNode::Enter() on #dst, but you can override.
	virtual void activate();

	//!assignment operator (only does shallow copy)
	Transition& operator=(const Transition& t) { src=t.src; dst=t.dst; return *this; }
protected:
	StateNode* src; //!< the node being transitioned from
	StateNode* dst; //!< the node being transitioned to
};

/*! @file
 * @brief Describes Transition, represents a transition between StateNodes.
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_2 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2003/03/01 20:53:26 $
 */

#endif
