#include "StateNode.h"
#include "Events/EventRouter.h"

StateNode::~StateNode() {
	if(isActive())
		DoStop();
	for(std::vector<Transition*>::iterator it=transitions.begin(); it!=transitions.end(); it++)
		delete *it;
	for(std::vector<StateNode*>::iterator it=nodes.begin(); it!=nodes.end(); it++)
		(*it)->RemoveReference();
	delete name;
}

void StateNode::addTransition(Transition* trans) {
	transitions.push_back(trans);
	if(isActive())
		trans->enable();
}

void StateNode::DoStart() {
	BehaviorBase::DoStart();
	name[0]='#';
	if(!issetup) {
		setup();
		issetup=true;
	}
	for(std::vector<Transition*>::iterator it=transitions.begin(); it!=transitions.end(); it++)
		(*it)->enable();
	erouter->postEvent(EventBase::stateMachineEGID,reinterpret_cast<unsigned int>(this),EventBase::activateETID,0,std::string(getName()+1),1);
	if(parent!=NULL)
		parent->transitionTo(this);
}

void StateNode::DoStop() {
	for(std::vector<Transition*>::iterator it=transitions.begin(); it!=transitions.end(); it++)
		(*it)->disable();
	for(std::vector<StateNode*>::iterator it=nodes.begin(); it!=nodes.end(); it++)
		(*it)->DoStop();
	if(!retain) {
		for(std::vector<StateNode*>::iterator it=nodes.begin(); it!=nodes.end(); it++)
			(*it)->RemoveReference();
		issetup=false;
	}
	name[0]='-';
	erouter->postEvent(EventBase::stateMachineEGID,reinterpret_cast<unsigned int>(this),EventBase::deactivateETID,0,std::string(getName()+1),0);
	BehaviorBase::DoStop();
}

void StateNode::setName(const char* n) {
	name=new char[strlen(n)+1];
	name[0]='-';
	strcpy(name+1,n);
}

void StateNode::transitionTo(StateNode*) {
	// may want to throw a status event here
}

void StateNode::transitionFrom(StateNode*) {
	// may want to throw a status event here
}

/*! @file 
 * @brief Describes StateNode, which is both a state machine controller as well as a node within a state machine itself
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_2 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2003/03/01 20:53:26 $
 */

