//-*-c++-*-
#ifndef INCLUDED_WalkToTargetMachine_h_
#define INCLUDED_WalkToTargetMachine_h_

#include "Behaviors/StateNode.h"
#include "Behaviors/Transitions/TimeOutTrans.h"
#include "Behaviors/Transitions/VisualTargetCloseTrans.h"
#include "Motion/MotionManager.h"

//! a state machine for walking towards a visual target
class WalkToTargetMachine : public StateNode {
public:
	//!constructor, pass parent, success and failure nodes, and VisionSourceID_t
	WalkToTargetMachine(VisionEventNS::VisionSourceID_t obj,StateNode* c=NULL, StateNode* l=NULL,StateNode* p=NULL)
		: StateNode("WalkToTarget",p),tracking(obj),timeout(NULL),close(c),lost(l),
			walker_id(MotionManager::invalid_MC_ID), headpointer_id(MotionManager::invalid_MC_ID) 
	{}
	
	void setup();

	virtual void DoStart();
	virtual void DoStop();

	//uses head to watch ball, walks towards it
	virtual void processEvent(const EventBase&);
	

protected:
	VisionEventNS::VisionSourceID_t tracking; //!< the object being tracked
	TimeOutTrans* timeout; //!< transition in case we lose the ball
	StateNode* close; //!< dest if we get close to the object
	StateNode* lost; //!< dest if we get lost
	MotionManager::MC_ID walker_id; //!< so we can walk
	MotionManager::MC_ID headpointer_id; //!< so we can point the head at the object

private:
	WalkToTargetMachine(const WalkToTargetMachine&); //!< don't call this
	WalkToTargetMachine operator=(const WalkToTargetMachine&); //!< don't call this
};

/*! @file
 * @brief Describes WalkToTargetMachine, a state machine for walking towards a visual target
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_2 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/03/09 02:45:21 $
 */

#endif
