//-*-c++-*-
#ifndef INCLUDED_MechaControllerBehavior_h_
#define INCLUDED_MechaControllerBehavior_h_

#include <iostream>
#include "Wireless/Wireless.h"
#include "Behaviors/BehaviorBase.h"
#include "Motion/MotionManager.h"
#include "Motion/WalkMC.h"
#include "Motion/HeadPointerMC.h"
#include "Events/EventRouter.h"
#include "Events/EventBase.h"
#include "SoundPlay/SoundManager.h"

// Predefinition for command packet reassembly mechanism
int mechacmd_callback(char *buf, int bytes);
// Class predefinition
class MechaControllerBehavior;

// Points to the one MechaControllerBehavior object that the input
// command stream is talking to. A kludge. Dunno how you're gonna
// make sure you're not using this uninitialized.
MechaControllerBehavior *theOneMCB = NULL;

//! Listens to mecha control commands coming in from the command port.
class MechaControllerBehavior : public BehaviorBase {
 friend int mechacmd_callback(char *buf, int bytes);

 protected:
	MotionManager::MC_ID walker_id;
	MotionManager::MC_ID head_id;
 
 private:
	static const char CMD_fwd  = 'f'; // Command bytes
	static const char CMD_roto = 'r';
	static const char CMD_side = 's';
	static const char CMD_opt0 = '0';
	static const char CMD_opt1 = '1';
	static const char CMD_opt2 = '2';
	static const char CMD_opt3 = '3';
	static const char CMD_opt4 = '4';
	static const char CMD_opt5 = '5';
	static const char CMD_opt6 = '6';
	static const char CMD_opt7 = '7';
	static const char CMD_opt8 = '8';
	static const char CMD_opt9 = '9';

	// Motion parameters
	float dx, dy, da; 

	// The last MCB object that was theOneMCB, so we can restore it
	// to prominence when we die. This is a nice gesture, but it doesn't
	// really make sense since we're all using the same port. But just
	// in case something changes and we don't do that, this mechanism
	// is in place.
	MechaControllerBehavior *theLastOneMCB;

	// The input command stream socket
	Socket *cmdsock;

	// Executes a command. Called by mechacmd_callback.
	void runCommand(unsigned char *command) {
		// First, turn off the stop-if-no-heartbeat timer
		erouter->removeTimer(this);

		// Extract the command parameter
		float param;
		unsigned char *paramp = (unsigned char *) &param;

		paramp[0] = command[1];
		paramp[1] = command[2];
		paramp[2] = command[3];
		paramp[3] = command[4];

		// Find out what type of command this is
		switch(command[0]) {
		case CMD_fwd:
			dx = param;
			break;
		case CMD_roto:
			da = param;
			break;
		case CMD_side:
			dy = param;
			break;
		case CMD_opt0:
		{
			HeadPointerMC *head =
				(HeadPointerMC*)motman->checkoutMotion(head_id);
			head->setJoints(0,0,0);
			motman->checkinMotion(head_id);
			break;
		}
		case CMD_opt1:
		case CMD_opt2:
		case CMD_opt3:
		case CMD_opt4:
			cout << "MECHA: hey, reprogram this button!" << endl;
			break;
		case CMD_opt5:
			sndman->PlayFile("howl.wav");
			break;
		case CMD_opt6:
			sndman->PlayFile("yap.wav");
			break;
		case CMD_opt7:
			sndman->PlayFile("whimper.wav");
			break;
		case CMD_opt8:
			sndman->PlayFile("growl.wav");
			break;
		case CMD_opt9:
			sndman->PlayFile("barkmed.wav");
			break;
		// The options button commands.
		default:
			cout << "MECHA: unknown command " << command[0] << endl;
		}

		// If the command was a new motion command, apply the
		// new motion parameters:
		switch(command[0]) {
		case CMD_fwd:
		case CMD_roto:
		case CMD_side:
			{
			WalkMC *walker =
			  (WalkMC*)motman->checkoutMotion(walker_id);
			walker->setTargetVelocity(dx,dy,da);
			motman->checkinMotion(walker_id);
			}
		}

		// Turn the stop-if-no-heartbeat timer back on--if we don't
		// hear from the mothership in three seconds, stop immediately.
		erouter->addTimer(this, 0, 3000, false);
	}

	MechaControllerBehavior(const MechaControllerBehavior&);
	MechaControllerBehavior operator=(const MechaControllerBehavior&);

 public:
	//! constructor
	MechaControllerBehavior() :
	  BehaviorBase(),
	  walker_id(MotionManager::invalid_MC_ID),
	  head_id(MotionManager::invalid_MC_ID),
	  dx(0), dy(0), da(0),
	  theLastOneMCB(theOneMCB),
	  cmdsock(wireless->socket(SocketNS::SOCK_STREAM, 2048, 2048))
	{ theOneMCB = this; }
	//! destructor
	virtual ~MechaControllerBehavior() { theOneMCB = theLastOneMCB; }

	virtual void DoStart() {
		// Behavior startup
		BehaviorBase::DoStart();
		// We listen to timers
		erouter->addListener(this, EventBase::timerEGID);
		// Enable walker
		walker_id = motman->addMotion(SharedObject<WalkMC>());
		// Enable head control
		head_id = motman->addMotion(SharedObject<HeadPointerMC>());
		// Turn on wireless
		wireless->setReceiver(cmdsock->sock, mechacmd_callback);
		wireless->listen(cmdsock->sock, config->main.mecha_port);
	}

	virtual void DoStop() {
		// Turn off timers
		erouter->forgetListener(this);
		// Close socket; turn wireless off
		wireless->close(cmdsock);
		// Stop moving
		WalkMC *walker = (WalkMC*)motman->checkoutMotion(walker_id);
		walker->setTargetVelocity(0,0,0);
		motman->checkinMotion(walker_id);
		// Disable walker
		motman->removeMotion(walker_id);
		// Disable head pointer
		motman->removeMotion(head_id);
		// Total behavior stop
		BehaviorBase::DoStop();
	}

	virtual void processEvent(const EventBase &) {
		// The only event we could possibly receive is the
		// stop-if-no-heartbeat timer. When that happens, we stop,
		// so here we go.
		WalkMC *walker = (WalkMC*)motman->checkoutMotion(walker_id);
		walker->setTargetVelocity(0,0,0);
		motman->checkinMotion(walker_id);
	}

	virtual const char* getName() const { return (isActive()?"#MechaController":"-MechaController"); } //!< returns name of behavior
};



// The command packet reassembly mechanism
int mechacmd_callback(char *buf, int bytes) {
  static char cb_buf[5];
  static int cb_buf_filled;

  // If there's an incomplete command in the command buffer, fill
  // up as much of the command buffer as we can and then execute it
  // if possible
  if(cb_buf_filled) {
    while((cb_buf_filled < 5) && bytes) {
      cb_buf[cb_buf_filled++] = *buf++;	// copy incoming buffer byte
      --bytes;				// decrement remaining byte ct.
    }
    // did we fill it? if so, execute! and mark buffer empty.
    if(cb_buf_filled == 5) {
      if(theOneMCB) theOneMCB->runCommand((unsigned char*) cb_buf);
      cb_buf_filled = 0;
    }
  }

  // now execute all complete bytes in the incoming buffer
  while(bytes >= 5) {
    if(theOneMCB) theOneMCB->runCommand((unsigned char *) buf);
    bytes -= 5;
    buf += 5;
  }

  // finally, store all remaining bytes in the command buffer
  while(bytes) {
    cb_buf[cb_buf_filled++] = *buf++;
    --bytes;
  }

  return 0;
}

#endif 
