#include "EvtRptBehavior.h"
#include "Events/EventRouter.h"
#include "Events/VisionEvent.h"
#include "Events/LocomotionEvent.h"
#include "Vision/Vision.h"

void EvtRptBehavior::DoStart() {
	BehaviorBase::DoStart();
	erouter->addListener(this,EventBase::locomotionEGID);
	erouter->addListener(this,EventBase::visionEGID,
				  VisionEventNS::MarkersSID);

	vision->enableEvents(VisionEventNS::MarkersSID);
	//vision->enableEvents(VisionEventNS::RedBallSID);
	//vision->enableEvents(VisionEventNS::PinkBallSID);
}

void EvtRptBehavior::DoStop() {
	vision->disableEvents(VisionEventNS::MarkersSID);
	//vision->disableEvents(VisionEventNS::RedBallSID);
	//vision->disableEvents(VisionEventNS::PinkBallSID);

	erouter->forgetListener(this);
	BehaviorBase::DoStop();
}

//this could be cleaned up event-wise (only use a timer when out of view)
void EvtRptBehavior::processEvent(const EventBase& event) {

	if(event.getGeneratorID() == EventBase::visionEGID &&
	   event.getTypeID() == EventBase::statusETID) {
		float horiz, vert;
		int prop;

		horiz = static_cast<const VisionEvent*>(&event)->getCenterX();
		vert  = static_cast<const VisionEvent*>(&event)->getCenterY();
		prop  = static_cast<const VisionEvent*>(&event)->getProperty();

		if(event.getSourceID() == VisionEventNS::RedBallSID)
			cout << "red  BALL seen";
		else if(event.getSourceID()==VisionEventNS::PinkBallSID)
			cout << "pink BALL seen";
		else if(event.getSourceID()==VisionEventNS::MarkersSID)
			cout << "MARKER " << prop << " seen";

		cout << " at h=" << horiz << " v=" << vert << endl;
	}
	else
	if(event.getGeneratorID() == EventBase::locomotionEGID &&
	   event.getTypeID() == EventBase::statusETID) {
		float x,y,a;

		x = static_cast<const LocomotionEvent*>(&event)->x;
		y = static_cast<const LocomotionEvent*>(&event)->y;
		a = static_cast<const LocomotionEvent*>(&event)->a;

		cout << "MOTION dx=" << x << " dy=" << y << " da=" << a << endl;
	}
}
			
/*! @file
 * @brief Implements EvtRptBehavior, which couts information about events it sees
 * @author tss (Creator)
 */


