//-*-c++-*-
#ifndef INCLUDED_DriveMeBehavior_h_
#define INCLUDED_DriveMeBehavior_h_

/* A very simple behavior that asks the user for WalkMC walking parameters
 * and a walk duration. The AIBO walks accordingly and then stands up, then
 * asks again. And so on and so on. */

#include "BehaviorBase.h"
#include "Motion/MotionManager.h"
#include "Motion/MotionSequenceMC.h"
#include "Shared/SharedObject.h"

class DriveMeBehavior : public BehaviorBase {
public:
	DriveMeBehavior();
	virtual ~DriveMeBehavior() {}

	virtual void DoStart();
	virtual void DoStop();

	virtual void processEvent(const EventBase& event);
			
	virtual const char* getName() const { return (isActive()?"#DriveMeBehavior":"-DriveMeBehavior"); }

protected:
	MotionManager::MC_ID walker_id;
	MotionManager::MC_ID stand_id;
	SharedObject< MotionSequenceMC<50> > stand;

	double last_dx, last_dy, last_da;
	unsigned int last_time;
};

#endif
