#include "ChaseBallBehavior.h"
#include "Events/EventRouter.h"
#include "Events/VisionEvent.h"
#include "Shared/WorldState.h"
#include "Motion/HeadPointerMC.h"
#include "Motion/WalkMC.h"
#include "Vision/Vision.h"

//! Converts degrees to radians
inline double DtoR(double deg) { return (deg/180.0*M_PI); }

void ChaseBallBehavior::DoStart() {
	BehaviorBase::DoStart();
	headpointer_id = motman->addMotion(SharedObject<HeadPointerMC>());
	walker_id = motman->addMotion(SharedObject<WalkMC>());
	erouter->addListener(this,EventBase::visionEGID);
  vision->enableEvents(VisionEventNS::RedBallSID);
  vision->enableEvents(VisionEventNS::PinkBallSID);
}

void ChaseBallBehavior::DoStop() {
  vision->disableEvents(VisionEventNS::RedBallSID);
  vision->disableEvents(VisionEventNS::PinkBallSID);
	erouter->forgetListener(this);
	motman->removeMotion(headpointer_id);
	motman->removeMotion(walker_id);
	BehaviorBase::DoStop();
}

//this could be cleaned up event-wise (only use a timer when out of view)
void ChaseBallBehavior::processEvent(const EventBase& event) {
	static float horiz=0,vert=0;
	if(event.getGeneratorID()==EventBase::visionEGID && event.getTypeID()==EventBase::statusETID) {
		horiz=static_cast<const VisionEvent*>(&event)->getCenterX();
		vert=static_cast<const VisionEvent*>(&event)->getCenterY();
	}

	WalkMC * walker = (WalkMC*)motman->checkoutMotion(walker_id);
	if(state->outputs[HeadOffset+PanOffset]<-.05 || state->outputs[HeadOffset+PanOffset]>.05)
		walker->setTargetVelocity(100,0,state->outputs[HeadOffset+PanOffset]*2);
	else
		walker->setTargetVelocity(160,0,0);
	motman->checkinMotion(walker_id);
	  
	//		cout << inview << ' ' << horiz << ' ' << vert << endl;

	double tilt=state->outputs[HeadOffset+TiltOffset]-vert*M_PI/7.5;
	double pan=state->outputs[HeadOffset+PanOffset]-horiz*M_PI/6;
	if(tilt<DtoR(-20))
		tilt=DtoR(-20);
	if(tilt>DtoR(70))
		tilt=DtoR(70);
	if(pan>DtoR(80))
		pan=DtoR(80);
	if(pan<DtoR(-80))
		pan=DtoR(-80);
	HeadPointerMC * headpointer= (HeadPointerMC*)motman->checkoutMotion(headpointer_id);
	headpointer->setJoints(tilt,pan,0);
	motman->checkinMotion(headpointer_id);
}
			
/*! @file
 * @brief Implements ChaseBallBehavior, which runs around after whatever the dog sees
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_2 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/03/09 02:45:21 $
 */


