//-*-c++-*-
#ifndef INCLUDED_ValueEditControl_h
#define INCLUDED_ValueEditControl_h

#include "ControlBase.h"
#include "Events/EventListener.h"
#include "Events/EventBase.h"
#include "MenuControl.h"
#include <vector>
#include "Motion/MotionManager.h"
#include "Events/EventRouter.h"
#include "Shared/WorldState.h"

//! allows real-time modification of a value through a pointer @todo needs some work to really be useful again
template< class T >
class ValueEditControl : public ControlBase, public EventListener {
 public:
	//!constructor
	ValueEditControl() : ControlBase(), display_id(MotionManager::invalid_MC_ID), target(NULL), cur(), copies(), modname() {}
	//!constructor
	ValueEditControl(const std::string& n, T* t) : ControlBase(n), display_id(MotionManager::invalid_MC_ID), target(t), cur(), copies(), modname() {}
	//!copy constructor
	ValueEditControl(const ValueEditControl<T>& vec) : ControlBase(vec), display_id(vec.display_id), target(vec.target), cur(vec.cur), copies(vec.copies), modname(vec.modname) {}
	//!assignment operator
	ValueEditControl operator=(const ValueEditControl<T>& vec) { ControlBase::operator=(vec); display_id=vec.display_id; target=vec.target; cur=vec.cur; copies=vec.copies; modname=vec.modname; return *this; }
	//!destructor
	virtual ~ValueEditControl() {}

	//!reads in current value from target
	virtual ControlBase * activate(MotionManager::MC_ID display) {
		display_id=display;
		cur=*target;
		erouter->forgetListener(this);
		refresh();
		return this;
	}
	//! will increment/decrement the current and then assign it to the target when head buttons pressed
	virtual void processEvent(const EventBase& e) {
		switch(e.getSourceID()) {
		case ButtonSourceID::HeadFrButSID: doNextItem(); doSelect(); break;
		case ButtonSourceID::HeadBkButSID: doNextItem(); doSelect(); break;
			//		case ButtonSourceID::ChinButSID: doSelect(); break;
		default:
			cout << "*** WARNING ValueEditControl got an unasked for event" << endl;
			break;
		}
	}
	//! displays current value
	virtual void refresh() {
		cout << getName();
		if(cur!=*target)
			cout << ": " << cur;
		cout << endl;
	}
	//! request to continue receiving events so we can modify the value while running
	virtual void pause() {
		erouter->addListener(this,EventBase(EventBase::buttonEGID,ButtonSourceID::HeadFrButSID,EventBase::deactivateETID,0));
		erouter->addListener(this,EventBase(EventBase::buttonEGID,ButtonSourceID::HeadBkButSID,EventBase::deactivateETID,0));
		//		erouter->addListener(this,EventBase(EventBase::buttonEGID,ButtonSourceID::ChinButSID,EventBase::deactivateETID,0));
	}

	//! if the value of the #target!=#cur, assigns the current value to the target and all the #copies
	virtual ControlBase * doSelect()   {
		if(*target!=cur) {
			*target=cur;
			for(typename std::vector<T*>::iterator it=copies.begin(); it!=copies.end(); it++)
				**it=cur;
			//			if(display) {
			//				display->flash(FaceLEDMask,100);
			//				display->clear();
			//			}
			cout << getName() << " set to " << *target << endl;
		}
		return NULL;
	}
	//! adds one to the current value
	virtual ControlBase * doNextItem() {
		cur++;
		refresh();
		return this;
	}
	//! subtracts one from the current value
	virtual ControlBase * doPrevItem() {
		cur--;
		refresh();
		return this;
	}
	//! prompts for a new value and calls doSelect();
	virtual ControlBase * doReadStdIn() {
		//		display->cset(FaceLEDMask,.5);
		std::cout << "#> " << std::flush;
		char str[50];
		std::cin >> str;
		cur = (T)atof(str);
		std::cout << std::endl;
		return doSelect();
	}

	/*!@name Target
	 * accessors for the target pointer */
	virtual T* getTarget() const { return target; } //!< returns the target pointer
	virtual ValueEditControl& setTarget(T* t) { target=t; return *this; } //!< sets the target pointer - the object pointed to will be overwritten on activate() @return @c *this
	//@}

	/*!@name Copies
	 * accessors for the copies vector, so you can assign the same value to several places if you need to */
	virtual std::vector<T*>& getCopies() { return copies; } //!< returns a reference to the vector #copies
	virtual ValueEditControl& addCopy(T* t) { copies.push_back(t); return *this; } //!< #copies.push_back(t)
	//@}

	//! shows current value
	virtual const char* getName() const {
		char s[20];
		//		if(*target==(int)*target)
		//			sprintf(s," (%d)",(int)*target);
		//		else
		snprintf(s,20," (%g)",(double)*target);
		modname=ControlBase::getName();
		modname+=s;
		return modname.c_str();
	}

 protected:
	MotionManager::MC_ID display_id; //!< display to flash LEDs and stuff
	T* target; //!< the main target
	T cur; //!< the value to use when set
	std::vector<T*> copies; //!< additional targets
	mutable std::string modname; //!< a temp variable to store the name for getName
};

/*! @file
 * @brief Defines ValueEditControl class, which will allow modification of a value through a pointer
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_2 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/03/03 01:18:12 $
 */

#endif
