#ifndef INCLUDED_SavePostureControl_h_
#define INCLUDED_SavePostureControl_h_

#include "ControlBase.h"
#include "Motion/PostureEngine.h"
#include <string>

//! Upon activation, saves the current position to a file name read from cin (stored in ms/data/...)
class SavePostureControl : public ControlBase {
 public:
	//! Constructor
	SavePostureControl(const std::string& n) : ControlBase(n), display_id(MotionManager::invalid_MC_ID) {}
	//! Destructor
	virtual ~SavePostureControl() {}

	virtual ControlBase* activate(MotionManager::MC_ID disp_id) {
		display_id=disp_id;
		return doReadStdIn();
	}

	ControlBase* doReadStdIn() {
		std::string filename;
		PostureEngine post;
		post.takeSnapshot();
		if(display_id!=MotionManager::invalid_MC_ID) {
			MMAccessor<LedMC> display(display_id);
			display.mc()->cset(FaceLEDMask,.5);
		}
		std::cout << "Enter name for posture file (in /ms/data):" << std::endl;
		std::cout << "#> " << std::flush;
		std::cin >> filename;
		std::cout << std::endl;
		filename="/ms/data/"+filename;
		post.SaveFile(filename.c_str());
		return NULL;
	}

 private:
	MotionManager::MC_ID display_id; //!< the LEDMC to use to give feedback that it's waiting for console input
};

/*! @file
 * @brief Defines SavePostureControl, which when activated, saves the current position to a file name read from cin (stored in ms/data/...)
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_2 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/03/03 01:18:12 $
 */

#endif
