//-*-c++-*-
#ifndef INCLUDED_PlaySoundControl_h_
#define INCLUDED_PlaySoundControl_h_

#include "FileBrowserControl.h"
#include "SoundPlay/SoundManager.h"

//! Upon activation, loads a position from a file name read from cin (stored in ms/data/motion...)
class PlaySoundControl : public FileBrowserControl {
 public:
	//! Constructor
	PlaySoundControl(const std::string& n)
		: FileBrowserControl(n,config->sound.root)
	{
		setFilter("*.wav");
	}
	//! Destructor
	virtual ~PlaySoundControl() {}

protected:
	//!does the actual loading of the MotionSequence
	virtual ControlBase* selectedFile(const std::string& f) {
		if(sndman)
			sndman->PlayFile(f.c_str());
		return this;
	}
};

/*! @file
 * @brief Defines PlaySoundControl, which when activated, plays a sound selected from the memory stick
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_2 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2003/04/30 03:55:49 $
 */

#endif
