//-*-c++-*-
#ifndef INCLUDED_BehaviorActivatorControl_h
#define INCLUDED_BehaviorActivatorControl_h

#include "ControlBase.h"
#include "BehaviorSwitchControl.h"

//! Upon activation, will tell the specified BehaviorSwitchControl to start or stop the behavior
class BehaviorActivatorControl : public ControlBase {
public:
	//! lets you tell it what action to perform
	enum Mode_t { start, stop, toggle };

	//!constructor
	BehaviorActivatorControl(const std::string& n, BehaviorSwitchControlBase* bscb, Mode_t m=toggle) : ControlBase(n), behswitch(bscb), mode(m) {}

	//!destructor
	virtual ~BehaviorActivatorControl() {}

	//! performs the action denoted by #mode
	virtual ControlBase * activate(MotionManager::MC_ID display_id) {
		switch(mode) {
		case start:
			behswitch->start();
			break;
		case stop:
			behswitch->stop();
			break;
		case toggle:
			behswitch->toggle();
			break;
		}
		if(display_id!=MotionManager::invalid_MC_ID) {
			MMAccessor<LedMC> display(display_id);
			display.mc()->flash(FaceLEDMask,100);
		}
		return NULL;
	}

protected:
	BehaviorSwitchControlBase* behswitch; //!< The behavior switch to activate/deactivate
	Mode_t mode; //!< the mode this control is in

private:
	BehaviorActivatorControl(const BehaviorActivatorControl&); //!< don't copy this class
	BehaviorActivatorControl operator=(const BehaviorActivatorControl&); //!< don't assign this class
};

/*! @file
 * @brief Defines ValueSetControl class, which will assign a value through a pointer upon activation
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_2 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/03/09 02:45:20 $
 */

#endif
