#include "Controller.h"
#include "Motion/EmergencyStopMC.h"
#include "Motion/LedMC.h"
#include "Motion/MMAccessor.h"
#include "Shared/SharedObject.h"
#include "Shared/WorldState.h"
#include "SoundPlay/SoundManager.h"

void Controller::DoStart() {
	BehaviorBase::DoStart();
	sndman->LoadFile(config->controller.select_snd);
	sndman->LoadFile(config->controller.next_snd);
	sndman->LoadFile(config->controller.prev_snd);
	sndman->LoadFile(config->controller.read_snd);
	sndman->LoadFile(config->controller.cancel_snd);
	erouter->addListener(this,EventBase::estopEGID);
	reset();
}

void Controller::DoStop() {
	sndman->ReleaseFile(config->controller.select_snd);
	sndman->ReleaseFile(config->controller.next_snd);
	sndman->ReleaseFile(config->controller.prev_snd);
	sndman->ReleaseFile(config->controller.read_snd);
	sndman->ReleaseFile(config->controller.cancel_snd);
	erouter->forgetListener(this);
	reset();
	BehaviorBase::DoStop();
}

bool Controller::trapEvent(const EventBase& e) {
	if(!chkCmdStack())
		return false;
	/*	if(e.getSourceID()==ButtonSourceID::LFrPawSID ||
			e.getSourceID()==ButtonSourceID::RFrPawSID ||
			e.getSourceID()==ButtonSourceID::LBkPawSID ||
			e.getSourceID()==ButtonSourceID::RBkPawSID)
			return false;*/
	setNext(cmdstack.top()->processControlEvent(e));
	return true;
}

void Controller::processEvent(const EventBase& event) {
	if(event.getTypeID()==EventBase::activateETID) { //estop just turned on
		if(display==MotionManager::invalid_MC_ID)
			activate();
	}	else { //estop just turned off
		if(display!=MotionManager::invalid_MC_ID)
			deactivate();
	}
}

void Controller::reset() {
	while(cmdstack.size()>1)
		pop();
	if(!cmdstack.empty()) {
		cmdstack.top()->deactivate();
		cmdstack.pop();
	}
}

void Controller::refresh() {
	if(!chkCmdStack())
		return;
	cmdstack.top()->refresh();
}

void Controller::push(ControlBase* c) {
	if(!chkCmdStack())
		return;
	cmdstack.top()->pause();
	cmdstack.push(c);
	setNext(cmdstack.top()->activate(display));
}

void Controller::pop() {
	cmdstack.top()->deactivate();
	cmdstack.pop();
	refresh();
}

Controller& Controller::setRoot(ControlBase* r) {
	reset();
	root=r;
	refresh();
	return *this;
}

Controller& Controller::setEStopID(MotionManager::MC_ID estopid) {
	estop_id=estopid;
	if(static_cast<EmergencyStopMC*>(motman->peekMotion(estopid))->getStopped()) {
		if(display==MotionManager::invalid_MC_ID)
			activate();
	} else {
		if(display!=MotionManager::invalid_MC_ID)
			deactivate();
	}		
	return *this;
}


void Controller::setNext(ControlBase* next) {
	if(next==NULL)
		pop();
	else if(next!=cmdstack.top())
		push(next);
}

void Controller::activate() {
	SharedObject<LedMC> leds;
	leds->setWeights(~FaceLEDMask,0);
	leds->setWeights(FaceLEDMask,.75);
	display=motman->addMotion(leds,MotionManager::kEmergencyPriority);
	erouter->addTrapper(this,EventBase::buttonEGID);
	if(!cmdstack.empty())
		cmdstack.top()->activate(display);
	else
		chkCmdStack();
}

void Controller::deactivate() {
	motman->removeMotion(display);
	//these two lines help prevent residual display in case that was the only MotionCommand using LEDs
	for(unsigned int i=LEDOffset; i<LEDOffset+NumLEDs; i++)
		motman->setOutput(NULL,i,0.f);
	display=MotionManager::invalid_MC_ID;
	erouter->removeTrapper(this);
	cmdstack.top()->pause();
}

bool Controller::chkCmdStack() {
	if(cmdstack.empty()) {
		if(root==NULL)
			return false;
		cmdstack.push(root);
		ControlBase * next = cmdstack.top()->activate(display);
		if(next==NULL)
			cout << "*** WARNING Controller root returned NULL on activate!" << endl;
		else if(next!=root)
			push(next);
	}
	return true;
}

/*! @file
 * @brief Implements Controller class, a behavior that should be started whenever the emergency stop goes on to provide menus for robot control
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_2 $
 * $Revision: 1.8 $
 * $State: Exp $
 * $Date: 2003/04/06 20:57:42 $
 */
