//-*-c++-*-
#ifndef INCLUDED_StartupBehavior_h_
#define INCLUDED_StartupBehavior_h_
#include "Behaviors/BehaviorBase.h"
#include "Motion/MotionManager.h"
#include <vector>

class Controller; // defined in Controller.h, don't actually need header file yet

//! This Behavior is the first (and only) behavior started once all the data structures and such are set up
class StartupBehavior : public BehaviorBase {
public:
	//! Constructor
	StartupBehavior();
	//! Destructor
	virtual ~StartupBehavior();

	//!Inherited
	//@{
	virtual void DoStart();
	virtual void DoStop();
	virtual void processEvent(const EventBase&);
	virtual const char * getName() const { return (isActive()?"#StartupBehavior":"-StartupBehavior"); }
	//@}
protected:
	//! Initializes the Controller menu structure
	virtual void SetupController(Controller& controller);

	std::vector<BehaviorBase*> spawned; //!< Behaviors spawned from DoStart, so they can automatically be stopped on DoStop
	MotionManager::MC_ID stop_id; //!< the main EmergencyStopMC
	MotionManager::MC_ID pid_id; //!< used to fade in the PIDs up to full strength (from initial zero) This is so the joints don't jerk on startup.
};

extern BehaviorBase& startupBehavior;

#endif
