#ifndef _AFS_TRIANGULATOR_H_
#define _AFS_TRIANGULATOR_H_

/*
 * Triangulator code for AIBO FastSLAM. Takes in the locations and
 * values of two bearings-only measurements and constructs a Gaussian for
 * the probable location of the landmark.
 */

#include "afsParticle.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Given two observation positions and two bearing measurements, this
 * routine places a probable location for the observed landmark into
 * the structure referenced by landmark (actually a gaussian describing the
 * most probable location). Returns true on success and false if there is
 * no good location information to be had here (e.g. observations were
 * taken too close together or the object is too far off, observations are
 * actually parallel lines, etc.). In the event of failure, it can be assumed
 * that the data referenced by landmark has not been altered.
 * Uses many many arguments just to make calls lots of fun. */
int afsTriangulator(double x1, double y1, double theta1,
		    double x2, double y2, double theta2,
		    afsLandmarkLoc *landmark);

#ifdef __cplusplus
}
#endif
#endif
