#ifndef _AFS_CONFIGURATION_H_
#define _AFS_CONFIGURATION_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Configuration options for AIBO FastSLAM
 */

/* Number of particles to use in the particle filter */
#define AFS_NUM_PARTICLES	400

/* Total number of landmarks */
#define AFS_NUM_LANDMARKS	12

/* Perturbation constants for the motion model */
#define AFS_PERTURB_DX_MEAN	0
#define AFS_PERTURB_DX_VARIANCE	0.1
#define AFS_PERTURB_DY_MEAN	0
#define AFS_PERTURB_DY_VARIANCE 0.1
#define AFS_PERTURB_DA_MEAN	0
#define AFS_PERTURB_DA_VARIANCE 0.01

/* Bounds on the angles of observations for which we'll do triangulation */
//#define AFS_MIN_TRIANG_ANGLE	10*M_PI/180
//#define AFS_MAX_TRIANG_ANGLE	170*M_PI/180
#define AFS_MIN_TRIANG_ANGLE	5*M_PI/180
#define AFS_MAX_TRIANG_ANGLE	175*M_PI/180

/* The variance of degree measurement in radians */
/* This is the measurement covariance we use to compute the Kalman gain.
 * Here, in bearings-only FastSLAM, it's dynamic. We increase the
 * covariance value linearly with the distance of the object. Measurements
 * about distant objects therefore have less effect on where the objects
 * are placed in the particle's map and don't drastically affect the
 * particle's weighting. This is a kludge, but then so is the EKF. */
/* AFS_MEASURE_VARIANCE is now the measurement variance at a
 * distance of a meter. AFS_VARIANCE_MULTIPLIER is multiplied by the
 * distance and added to AFS_MEASUREMENT_VARIANCE to describe a linear
 * change in covariance. It is a Good Idea to set this value such that
 * covariance never becomes negative! */
/* If you don't like any of this, set AFS_VARIANCE_MULTIPLIER to 1
 * and don't think about it. */
#define AFS_MEASURE_VARIANCE	2*M_PI/180
#define AFS_VARIANCE_MULTIPLIER AFS_MEASURE_VARIANCE/4000

/* A fudge factor for triangulated point covariance estimates. */
#define AFS_COVARIANCE_FUDGE	15

#ifdef __cplusplus
}
#endif
#endif
