#ifndef INCLUDED_TextCmdHandler_h
#define INCLUDED_TextCmdHandler_h

#include <AnalyzerAPI.h>
#include <AnalyzerError.h>
#include "Wireless.h"
#include <OPENR/OPENRAPI.h>
#include "Events/TextMsgEvent.h"
#include "Events/EventRouter.h"

#define TEXTCMD_BUFSIZE 512

class TextCmdHandler {
  public:
    TextCmdHandler() : cmdloc(0) {};
    ~TextCmdHandler() {}

    int registerText(char *buf, int bytes) {
      int bufloc=0;
      while (bufloc<bytes) {
        char bufchar=buf[bufloc++];
        if (bufchar!='\n' && bufchar!='\r') {
          cmd[cmdloc++]=bufchar;
        } else {
          cmd[cmdloc]='\0';
          parseText(cmdloc);
          cmdloc=0;
        }
      }
      return bytes;
    }

    void printError() {
      sout->printf("%s: command not found\n", cmd);
    }
    
    void parseText(int length) {
      char *args=NULL;
      int cmdlen=length, arglen=0;
      if (length<=1) return;
      args=index(cmd,' ');
      if (args!=NULL) {
        cmdlen=int(args)-int(cmd);
        arglen=length-cmdlen-1;
        *(args++)='\0';
      }

      if (cmdlen==2 && strncasecmp(cmd,"ps",cmdlen)==0) {
        statBehaviors(args);
      } else if (cmdlen==3 && strncasecmp(cmd,"msg",cmdlen)==0) {
        textMsg(args);
      } else if (cmdlen==4 && strncasecmp(cmd,"stop",cmdlen)==0) {
        stopBehavior(args);
      } else if (cmdlen==4 && strncasecmp(cmd,"free",cmdlen)==0) {
        freeMemory(args);
      } else if (cmdlen==4 && strncasecmp(cmd,"walk",cmdlen)==0) {
        walkCmd(args);
      } else if (cmdlen==4 && strncasecmp(cmd,"help",cmdlen)==0) {
        usage(args);
      } else if (cmdlen==5 && strncasecmp(cmd,"start",cmdlen)==0) {
        startBehavior(args);
      } else if (cmdlen==5 && strncasecmp(cmd,"event",cmdlen)==0) {
        createEvent(args);
      } else if (cmdlen==5 && strncasecmp(cmd,"usage",cmdlen)==0) {
        usage(args);
      } else if (cmdlen==5 && strncasecmp(cmd,"estop",cmdlen)==0) {
        emergencyStop(args);
      } else if (cmdlen==6 && strncasecmp(cmd,"motion",cmdlen)==0) {
        motionCmd(args);
      } else if (cmdlen==6 && strncasecmp(cmd,"estart",cmdlen)==0) {
        emergencyStart(args);
      } else if (cmdlen==6 && strncasecmp(cmd,"config",cmdlen)==0) {
        configCmd(args);
      } else if (cmdlen==6 && strncasecmp(cmd,"reboot",cmdlen)==0) {
        reboot(args);
      } else if (cmdlen==7 && strncasecmp(cmd,"sysinfo",cmdlen)==0) {
        sysInfo(args);
      } else if (cmdlen==8 && strncasecmp(cmd,"iwconfig",cmdlen)==0) {
        netStat(args);
      } else if (cmdlen==8 && strncasecmp(cmd,"shutdown",cmdlen)==0) {
        shutdown(args);
      }
    }

    void shutdown(char */*args*/) {
      OBootCondition bc(0);
      OPENR::Shutdown(bc);
    }

    void reboot(char */*args*/) {
      OBootCondition bc(obcbBOOT_TIMER, 0, obcbttRELATIVE);
      OPENR::Shutdown(bc);
    }
    
    void startBehavior(char */*args*/) {
    }

    void stopBehavior(char */*args*/) {
    }

    void statBehaviors(char */*args*/) {
    }

    void emergencyStop(char */*args*/) {
    }

    void emergencyStart(char */*args*/) {
    }

    void freeMemory(char */*args*/) {
      size_t freemem;
      if (AnalyzerGetSizeOfFreeMemory(&freemem)==azrSUCCESS) {
        sout->printf("%d bytes free\n",freemem);
      } else {
        sout->printf("Aperios error: getsizeoffreememory failed\n");
      }
    }

    void sysInfo(char */*args*/) {
      char buf[80];
      if (OPENR::GetRobotDesign(buf)==oSUCCESS) {
        sout->printf("model: %s\n",buf);
      } else {
        sout->printf("Aperios error: getrobotdesign failed\n");
      }
    }

    void textMsg(char *args) {
      erouter->postEvent(new TextMsgEvent(args));
    }

    void createEvent(char */*args*/) {
    }

    void motionCmd(char */*args*/) {
    }

    void configCmd(char */*args*/) {
    }

    void walkCmd(char */*args*/) {
    }

    void netStat(char */*args*/) {
//                             Rate
//                             Statistics
    }

    void usage(char */*args*/) {
      sout->printf("cmd <args>:\n");
      sout->printf("ps:\t\tlist behaviors\n");
      sout->printf("msg:\t\ttextmsg event\n");
      sout->printf("start:\t\tstart behavior\n");
      sout->printf("stop:\t\tstop behavior\n");
      sout->printf("free:\t\tdisplay free memory\n");
      sout->printf("walk:\t\texecute walk command\n");
      sout->printf("event:\t\tcreate other event\n");
      sout->printf("estop:\t\temergency stop\n");
      sout->printf("estart:\t\temergency unpause\n");
      sout->printf("motion:\t\tmotion command\n");
      sout->printf("config:\t\ttekkotsu.cfg config command\n");
      sout->printf("reboot:\t\treboot aibo\n");
      sout->printf("sysinfo:\tdisplay system information\n");
      sout->printf("iwconfig:\tdisplay wireless information\n");
      sout->printf("shutdown:\tshutdown aibo\n");
    }

  protected:
    char cmd[TEXTCMD_BUFSIZE];
    int cmdloc;
};

extern TextCmdHandler* textcmd;
int textcmd_callback(char *buf, int bytes);

#endif
