//-*-c++-*-
#ifndef INCLUDED_Factory_h_
#define INCLUDED_Factory_h_

//! A lightweight class to override for constructing new objects (if you need to pass constructors parameters, etc.)
/*! Say you don't want to construct your behavior at boot-up (if it's big and might not even be
 *  used) but your behavior needs special setup during creation (might be invoked
 *  several difference ways for instance) then you'll want to subclass this to do the setup when
 *  your behavior is activated.\n
 *  The default is to simply call the default constructor */
template<class B>
class Factory {
public:
	static B* construct() { return new B(); } //!< Just returns a new B
};

//! Uses template to specify a constant parameter to the constructor
template<class B, class A1, A1 a1>
class Factory1Arg : public Factory<B> {
public:
	static B* construct() { return new B(a1); } //!< Just returns a new B constructed with arguments @a a1
};

/*! @file
 * @brief Defines Factory, a lightweight class to override for constructing new objects
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_1 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2003/01/09 02:02:59 $
 */

#endif

