#include <OPENR/core_macro.h>
#include "RemoteProcess.h"
#include <stdio.h>

RemoteProcess::RemoteProcess() : RPOPENR_isready(true)
{
  // usercode: constructor here
}

RemoteProcess::~RemoteProcess()
{
  // usercode: destructor here
}

void
RemoteProcess::start()
{
  // usercode: objects connected
  // code below is a simple example

  if (RPOPENR_isReady()) {
    RPOPENR_send("hello aibo",11);
    printf("local: hello aibo");
  }
}

void
RemoteProcess::data_received(const char *buf)
{
  // usercode: message received
  // code below is a simple example

  printf("remote: %s\n",buf);
}

OStatus
RemoteProcess::DoInit(const OSystemEvent& event)
{
  NEW_ALL_SUBJECT_AND_OBSERVER;
  REGISTER_ALL_ENTRY;
  SET_ALL_READY_AND_NOTIFY_ENTRY;
  return oSUCCESS;
}

OStatus
RemoteProcess::DoStart(const OSystemEvent& event)
{
    ENABLE_ALL_SUBJECT;
    ASSERT_READY_TO_ALL_OBSERVER;
    start();
    return oSUCCESS;
}

OStatus
RemoteProcess::DoStop(const OSystemEvent& event)
{
    DISABLE_ALL_SUBJECT;
    DEASSERT_READY_TO_ALL_OBSERVER;
    return oSUCCESS;
}

OStatus
RemoteProcess::DoDestroy(const OSystemEvent& event)
{
    DELETE_ALL_SUBJECT_AND_OBSERVER;
    return oSUCCESS;
}

void
RemoteProcess::RPOPENR_notify(const ONotifyEvent& event) {
  const char *buf = (const char *)event.Data(0);
  data_received(buf);
  observer[event.ObsIndex()]->AssertReady();
}

int
RemoteProcess::RPOPENR_send(char *buf, int bufsize) {
  if (RPOPENR_isready && bufsize>0) {
    RPOPENR_isready=false;
    subject[sbjRPOPENRSendString]->SetData(buf, bufsize);
    subject[sbjRPOPENRSendString]->NotifyObservers();
    return bufsize;
  }
  return 0;
}

