//-*-c++-*-
#ifndef INCLUDED_TextMsgEvent_h
#define INCLUDED_TextMsgEvent_h

#include "EventBase.h"

//! Extends EventBase to also include actual message text
class TextMsgEvent : public EventBase {
 public:
	//! Constructor
  TextMsgEvent() : EventBase(EventBase::textmsgEGID,(unsigned int)-1, EventBase::activateETID,0),_token(0) { setText(""); }

  //! Constructor, pass a text msg
  TextMsgEvent(const char *text) : EventBase(EventBase::textmsgEGID,(unsigned int)-1, EventBase::activateETID,0),_token(0) { setText(text); }
  
  const char* getText() const { return _text; } //!< returns the text
  TextMsgEvent& setText(const char *text) { strncpy(_text, text, 127); return *this; } //!< sets the text
  
  int getToken() const { return _token; } //!< returns the token
  TextMsgEvent& setToken(int token) { _token=token; return *this;} //!< sets the token
      
	virtual unsigned int getBinSize() const {
		unsigned int used=EventBase::getBinSize();
		used+=creatorSize("EventBase::TextMsgEvent");
		used+=strlen(_text)+stringpad;
		used+=sizeof(_token);
		return used;
	}

	virtual unsigned int LoadBuffer(const char buf[], unsigned int len) {
		unsigned int origlen=len;
		unsigned int used;
		if(0==(used=EventBase::LoadBuffer(buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=checkCreator("EventBase::TextMsgEvent",buf,len,true))) return 0;
		len-=used; buf+=used;
		char*tmp=_text;
		if(0==(used=decode(tmp,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=decode(_token,buf,len))) return 0;
		len-=used; buf+=used;
		return origlen-len;	
	}

	virtual unsigned int SaveBuffer(char buf[], unsigned int len) const {
		unsigned int origlen=len;
		unsigned int used;
		if(0==(used=EventBase::SaveBuffer(buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=saveCreator("EventBase::TextMsgEvent",buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=encode(_text,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=encode(_token,buf,len))) return 0;
		len-=used; buf+=used;
		return origlen-len;
	}

 protected:
  char _text[128]; //!< the unmodified arguments passed to the command
  int _token;      //!< for future expansion, to support centralized parsing
};

#endif
