#include "WalkToTargetMachine.h"
#include "Motion/HeadPointerMC.h"
#include "Motion/WalkMC.h"
#include "Vision/Vision.h"
#include "Shared/WorldState.h"

//! Converts degrees to radians
inline double DtoR(double deg) { return (deg/180.0*M_PI); }

void WalkToTargetMachine::setup() {
	if(close!=NULL)
		addTransition(new VisualTargetCloseTrans(this,close,tracking));
	if(lost!=NULL)
		addTransition(timeout=new TimeOutTrans(this,lost,500));
}


void WalkToTargetMachine::DoStart() {
	StateNode::DoStart();
	headpointer_id = motman->addMotion(SharedObject<HeadPointerMC>());
	walker_id = motman->addMotion(SharedObject<WalkMC>());
	erouter->addListener(this,EventBase::visionEGID,tracking);
  vision->enableEvents(tracking);
}

void WalkToTargetMachine::DoStop() {
  vision->disableEvents(tracking);
	erouter->forgetListener(this);
	motman->removeMotion(headpointer_id);
	motman->removeMotion(walker_id);
	StateNode::DoStop();
}

//this could be cleaned up event-wise (only use a timer when out of view)
void WalkToTargetMachine::processEvent(const EventBase& event) {
	if(timeout)
		timeout->resetTimer();
	static float horiz=0,vert=0;
	const VisionEvent *ve = dynamic_cast<const VisionEvent*>(&event);
	if(ve!=NULL && event.getTypeID()==EventBase::statusETID) {
		horiz=ve->getCenterX();
		vert=ve->getCenterY();
	} else
		return;

	//		cout << inview << ' ' << horiz << ' ' << vert << endl;

	double tilt=state->outputs[HeadOffset+TiltOffset]-vert*M_PI/6;
	double pan=state->outputs[HeadOffset+PanOffset]-horiz*M_PI/7.5;
	if(tilt<DtoR(-20))
		tilt=DtoR(-20);
	if(tilt>DtoR(70))
		tilt=DtoR(70);
	if(pan>DtoR(80))
		pan=DtoR(80);
	if(pan<DtoR(-80))
		pan=DtoR(-80);
	HeadPointerMC * headpointer= (HeadPointerMC*)motman->checkoutMotion(headpointer_id);
	headpointer->setJoints(tilt,pan,0);
	motman->checkinMotion(headpointer_id);

	WalkMC * walker = (WalkMC*)motman->checkoutMotion(walker_id);
	if(pan<-.05 || pan>.05)
		walker->setTargetVelocity(100,0,pan);
	else
		walker->setTargetVelocity(160,0,0);
	motman->checkinMotion(walker_id);
}

/*! @file
 * @brief Implements WalkToTargetMachine, a state machine for walking towards a visual target
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_1 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/03/09 02:45:21 $
 */

