//-*-c++-*-
#ifndef INCLUDED_EventLogger_h_
#define INCLUDED_EventLogger_h_

#include "MenuControl.h"
#include "Events/EventListener.h"
#include <fstream>

//! allows logging of events to the console or a file
class EventLogger : public MenuControl, public EventListener {
public:
	//!constructor
	EventLogger();

	//!opens a custom (embedded) menu to toggle individual EGIDs
	virtual ControlBase* doSelect();

	//!sends all events received to stdout and/or logfile
	virtual void processEvent(const EventBase& event);

	//!Prompts for a filename and returns the string
	std::string getFilename();

protected:
	//!sets the status char of slot @a i to @a c
	void setStatus(unsigned int i, char c);

	//!if a filename is given, events are logged to here
	std::ofstream logfile;

	//!controls the level of verbosity - currently 0 through 2
	unsigned int verbosity;
};

/*! @file
 * @brief Describes EventLogger, which allows logging of events to the console or a file
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_1 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/03/03 01:18:11 $
 */

#endif
