
#ifndef Wireless_h_DEFINED
#define Wireless_h_DEFINED

#include <OPENR/OObject.h>
#include <OPENR/OSubject.h>
#include <OPENR/OObserver.h>
#include <ant.h>
#include "MMCombo/def.h"
#include "Socket.h"

#define WIRELESS_MAX_SOCKETS 15
#define WIRELESS_DEF_RECV_SIZE 1024
#define WIRELESS_DEF_SEND_SIZE 1024

using namespace SocketNS;

class Wireless {
public:
    Wireless();
    ~Wireless();

    bool isConnected(int sock) { return sockets[sock]->state
                                          ==CONNECTION_CONNECTED; }
    bool isReady(int sock) { return !sockets[sock]->tx; }
    bool hasData(int sock) { return !sockets[sock]->rx; }

    Socket* socket(TransportType_t ttype);
    Socket* socket(TransportType_t ttype, int recvsize, int sendsize);
    Socket socket(TransportType_t ttype, int recvsize, int sendsize, int
               recvwindow, int sendwindow);
    int listen(int sock, int port);
    int connect(int sock, const char* ipaddr, int port);
    void send(int sock);
    void blockingSend(int sock);
    void receive(int sock, int (*rcvcbckfn) (char*, int) );
    void receive(int sock);
    void setReceiver(int sock, int (*rcvcbckfn) (char*, int) );
    void close(int sock);
    void close(Socket &sobj);
    void close(Socket *sobj);
    
    void ListenCont (void* msg);
    void BindCont   (void* msg);
    void ConnectCont(void* msg);
    void SendCont   (void* msg);
    void ReceiveCont(void* msg);
    void CloseCont  (void* msg);

private:
    antStackRef ipstackRef;
    OID myOID;
    Socket* sockets[WIRELESS_MAX_SOCKETS];
    int sock_num;

private:
    Wireless(const Wireless&);
    Wireless& operator= (const Wireless&);
};

extern Wireless* wireless;

#endif // Wireless_h_DEFINED
