#include "Socket.h"
#include <stdio.h>
#include "Wireless.h"
#include "Shared/Config.h"

Socket* sout=NULL;
Socket* serr=NULL;

byte*
Socket::getWriteBuffer()
{
  return writeData+writeSize;
}

byte*
Socket::getWriteBuffer(int bytesreq)
{
  if (sendBufSize-writeSize>=bytesreq
      && state==CONNECTION_CONNECTED)
    return writeData+writeSize;
  else
    return NULL;
}

void
Socket::write(int size)
{
  writeSize+=size;
  flush();
}

int
Socket::read()
{
  return -1;
}

byte*
Socket::getReadBuffer()
{
  return readData+readSize;
}

void
Socket::init()
{
  sendSize=0;
  writeSize=0;
}

void
Socket::flush()
{
  if (!tx) {
    byte *tempData=sendData;
    int tempSize=sendSize;
    sendData=writeData;
    writeData=tempData;
    sendSize=writeSize;
    writeSize=tempSize;
    wireless->send(sock); 
  }
}

void
Socket::hard_flush()
{
  wireless->blockingSend(sock); 
}

int
Socket::perror(const char *fmt, ...)
{
  if (state!=CONNECTION_CONNECTED
      || config->main.error_level>0) return 0;
  if (sendBufSize-writeSize<256) {
    flush();
    if (sendBufSize-writeSize<256)
      return -1;
  }

  int ret;
  va_list al;
  va_start(al,fmt);
  ret=vsprintf((char *)(writeData+writeSize), fmt, al);
  va_end(al);
  writeSize+=ret;
  flush();
  return ret;
}

int
Socket::pdebug(int dlevel, const char *fmt, ...)
{
  if (state!=CONNECTION_CONNECTED
      || config->main.debug_level>dlevel) return 0;
  if (sendBufSize-sendSize<256) {
    hard_flush();
    if (sendBufSize-sendSize<256)
      return -1;
  }

  int ret;
  va_list al;
  va_start(al,fmt);
  ret=vsprintf((char *)(sendData+sendSize), fmt, al);
  va_end(al);
  sendSize+=ret;
  hard_flush();
  return ret;
}

int
Socket::pprintf(int vlevel, const char *fmt, ...)
{
  if (state!=CONNECTION_CONNECTED
      || config->main.verbose_level>vlevel) return 0;
  if (sendBufSize-writeSize<256) {
    flush();
    if (sendBufSize-writeSize<256)
      return -1;
  }

  int ret;
  va_list al;
  va_start(al,fmt);
  ret=vsprintf((char *)(writeData+writeSize), fmt, al);
  va_end(al);
  writeSize+=ret;
  flush();
  return ret;
}

int
Socket::printf(const char *fmt, ...)
{
  if (state!=CONNECTION_CONNECTED) return 0;
  if (sendBufSize-writeSize<256) {
    flush();
    if (sendBufSize-writeSize<256)
      return -1;
  }

  int ret;
  va_list al;
  va_start(al,fmt);
  ret=vsprintf((char *)(writeData+writeSize), fmt, al);
  va_end(al);
  writeSize+=ret;
  flush();
  return ret;

}

int
Socket::write(byte *buf, int size)
{
  if (size>=sendBufSize-writeSize) return -1;
  memcpy(writeData+writeSize,buf,size);
  writeData+=writeSize;
  return size;
}

int
Socket::read(byte *buf, int size)
{
/*  if (size>=recvBufSize-recvPos) return -1;
  memcpy(buf,recvData+recvPos,size);*/
  return -1;
}
