#include "get_time.h"

#ifndef PLATFORM_APERIOS
extern unsigned int simulator_time; //!< the current time the simulator wants it to be
unsigned int get_time() {
  return simulator_time;
}
#else
#include <MCOOP.h>
unsigned int get_time() {
  static struct SystemTime time;
  GetSystemTime(&time);
  return time.seconds*1000+time.useconds/1000;
}
#endif

/*! @file
 * @brief Implementation of get_time(), a simple way to get the current time since boot in milliseconds
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-0_95 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/01/09 02:03:00 $
 */
