#include "WorldState.h"
#include "WorldStateSerializer.h"
#include "Shared/Config.h"
#include "Shared/get_time.h"
#include <string.h>
#include "RobotInfo.h"

WorldStateSerializer::WorldStateSerializer() : wsJoints(NULL), wsPIDs(NULL) {
  wsJoints=wireless->socket(SocketNS::SOCK_STREAM, 1024, 2048);
  wireless->listen(wsJoints->sock, config->main.wsjoints_port);
  wsPIDs=wireless->socket(SocketNS::SOCK_STREAM, 1024, 2048);
  wireless->listen(wsPIDs->sock, config->main.wspids_port);
}

void
WorldStateSerializer::serialize() {
  char *buf=(char*)wsPIDs->getWriteBuffer((NumPIDJoints*3+1)*4);
  if (buf) {
    encode(&buf,state->lastSensorUpdateTime);
    encodeDoublesAsFloats(&buf,(double*)state->pids,NumPIDJoints*3);
    wsPIDs->write((NumPIDJoints*3+1)*4);
  }
  
  buf=(char*)wsJoints->getWriteBuffer((NumPIDJoints*2+15)*4);
  if (buf) {
    encode(&buf,state->lastSensorUpdateTime);
    encodeDoublesAsFloats(&buf,&state->outputs[PIDJointOffset], NumPIDJoints);
    encodeDoublesAsFloats(&buf,state->sensors,6);
    encodeDoublesAsFloats(&buf,state->buttons,8);
    encodeDoublesAsFloats(&buf,state->pidduties,NumPIDJoints);
    wsJoints->write((NumPIDJoints*2+15)*4);
  }
}
