#ifndef INCLUDED_Serializer_h
#define INCLUDED_Serializer_h

class Serializer {
public:
  
protected:
  template<class T>
  inline static void encode(char **dst, T value) {
    memcpy(*dst, (char *)&value, sizeof(T));
//    hostToNetwork(*dst, (char *)&value, sizeof(T));
//    it'd be nice to use network byte order, but we'll save the aibo
//    extra work
    (*dst) += sizeof(T);
  }

  inline static void hostToNetwork(char *dst, char *src, int length) {
    for (int i=0; i<length; i++)
      dst[length-1-i]=src[i];
  }

  inline static void encode(char **dst, char *src, int length) {
    memcpy(*dst, src, length);
    (*dst) +=length;
  }

  inline static void encodeDoublesAsFloats(char **dst, double *src, int length) {
    for (int i=0; i<length; i++)
      encode(dst, float(src[i]));
  }
};

#endif
