#ifndef INCLUDED_Config_h
#define INCLUDED_Config_h

class Config {
  public:
    Config(const char* filename) :
      wireless(), vision(), main(), behaviors(), controls(), motion(),
      worldmodel(), worldmodel2() { readConfig(filename); }
    ~Config() {}

    enum section_t {
      sec_wireless=0,
      sec_vision,
      sec_main,
      sec_behaviors,
      sec_controls,
      sec_motion,
      sec_worldmodel,
      sec_worldmodel2,
      sec_invalid
    };

    struct wireless_config {
      int id;
      
      wireless_config () : id(1) {}
    } wireless;

    struct vision_config {
      int white_balance;
      int gain;
      int shutter_speed;
      int resolution;
      char thresh[30];
      char colors[30];
      int raw_port;
      int rle_port;
      int obj_port;
      
      vision_config() : white_balance(3), gain(2), shutter_speed(2), resolution(2), thresh(), colors(), raw_port(0), rle_port(0), obj_port(0) {}
    } vision;
    
    struct main_config {
      int console_port;
      int stderr_port;
      int error_level;
      int debug_level;
      int verbose_level;
      int wsjoints_port;
      int wspids_port;

      main_config()
				: console_port(0), stderr_port(0), error_level(0), debug_level(0),
					 verbose_level(0),wsjoints_port(0),wspids_port(0)
			{ }
    } main;

    struct behaviors_config {
    } behaviors;
    
    struct controls_config {
    } controls;
    
    struct motion_config {
    } motion;

    struct worldmodel_config {
      int ego_port;
      int grid_port;
      int loc_port;
      
      worldmodel_config() : ego_port(0), grid_port(0), loc_port(0) {}
    } worldmodel;

    struct worldmodel2_config {
      int dm_port, hm_port, gm_port, fs_port;
      worldmodel2_config() : dm_port(0), hm_port(0), gm_port(0), fs_port(0) {}
    } worldmodel2;

    void readConfig(const char* filename);
};

extern Config* config;

#endif
