#include <Shared/Config.h>
#include <stdio.h>
#include <string>

Config* config=NULL;

void Config::readConfig(const char* filename) {
  FILE* fp = fopen(filename, "r");
  char buf[80], key[30], value[50];
  section_t section=sec_invalid;
  if (fp==NULL) return; // ALTODO
  
  while (fscanf(fp,"%79[^\n]\n", buf)!=EOF) {
    if (sscanf(buf,"[%29[^]]",key)>0) {
      if (strncasecmp(key,"wireless",29)==0) {
        section=sec_wireless;
      } else if (strncasecmp(key,"vision",29)==0) {
        section=sec_vision;
      } else if (strncasecmp(key,"main",29)==0) {
        section=sec_main;
      } else if (strncasecmp(key,"behaviors",29)==0) {
        section=sec_behaviors;
      } else if (strncasecmp(key,"controls",29)==0) {
        section=sec_controls;
      } else if (strncasecmp(key,"motion",29)==0) {
        section=sec_motion;
      } else if (strncasecmp(key,"worldmodel",29)==0) {
        section=sec_worldmodel;
      } else if (strncasecmp(key,"worldmodel2",29)==0) {
        section=sec_worldmodel2;
      } else {
        section=sec_invalid;
      }
    } else if (sscanf(buf,"%29[^=]=%49s",key,value)>1) {
      switch (section) {
        case sec_wireless:
          if (strncasecmp(key,"id",29)==0) {
            wireless.id=atoi(value);
          }
          break;
        case sec_vision:
          if (strncasecmp(key,"white_balance",29)==0) {
            if (strncasecmp(value,"indoor",49)==0) {
              vision.white_balance=1;
            } else if (strncasecmp(value,"flourescent",49)==0) {
              vision.white_balance=3;
            } else if (strncasecmp(value,"outdoor",49)==0) {
              vision.white_balance=2;
            }
          } else if (strncasecmp(key,"gain",29)==0) {
            if (strncasecmp(value,"low",49)==0) {
              vision.gain=1;
            } else if (strncasecmp(value,"mid",49)==0) {
              vision.gain=2;
            } else if (strncasecmp(value,"high",49)==0) {
              vision.gain=3;
            }
          } else if (strncasecmp(key,"shutter_speed",29)==0) {
            if (strncasecmp(value,"slow",49)==0) {
              vision.shutter_speed=1;
            } else if (strncasecmp(value,"mid",49)==0) {
              vision.shutter_speed=2;
            } else if (strncasecmp(value,"fast",49)==0) {
              vision.shutter_speed=3;
            }
          } else if (strncasecmp(key,"resolution",29)==0) {
            if (strncasecmp(value,"full",49)==0) {
              vision.resolution=1;
            } else if (strncasecmp(value,"half",49)==0) {
              vision.resolution=2;
            } else if (strncasecmp(value,"quarter",49)==0) {
              vision.resolution=3;
            }
          } else if (strncasecmp(key,"thresh",29)==0) {
            strncpy(vision.thresh,value,29);
          } else if (strncasecmp(key,"colors",29)==0) {
            strncpy(vision.colors,value,29);
          } else if (strncasecmp(key,"raw_port",29)==0) {
            vision.raw_port=atoi(value);
          } else if (strncasecmp(key,"rle_port",29)==0) {
            vision.rle_port=atoi(value);
          } else if (strncasecmp(key,"obj_port",29)==0) {
            vision.obj_port=atoi(value);
          }
          break;
        case sec_main:
          if (strncasecmp(key,"console_port",29)==0) {
            main.console_port=atoi(value);
          } else if (strncasecmp(key,"stderr_port",29)==0) {
            main.stderr_port=atoi(value);
          } else if (strncasecmp(key,"error_level",29)==0) {
            main.error_level=atoi(value);
          } else if (strncasecmp(key,"debug_level",29)==0) {
            main.debug_level=atoi(value);
          } else if (strncasecmp(key,"verbose_level",29)==0) {
            main.verbose_level=atoi(value);
          } else if (strncasecmp(key,"wsjoints_port",29)==0) {
            main.wsjoints_port=atoi(value);
          } else if (strncasecmp(key,"wspids_port",29)==0) {
            main.wspids_port=atoi(value);
	        }
          break;
        case sec_behaviors:
          break;
        case sec_controls:
          break;
        case sec_motion:
          break;
        case sec_worldmodel:
          if (strncasecmp(key,"ego_port",29)==0) {
            worldmodel.ego_port=atoi(value);
          } else if (strncasecmp(key,"grid_port",29)==0) {
            worldmodel.grid_port=atoi(value);
          } else if (strncasecmp(key,"loc_port",29)==0) {
            worldmodel.loc_port=atoi(value);
          }
          break;
        case sec_worldmodel2:
          if (strncasecmp(key,"dm_port",29)==0)
	    worldmodel2.dm_port = atoi(value);
          else if (strncasecmp(key,"hm_port",29)==0)
	    worldmodel2.hm_port = atoi(value);
          else if (strncasecmp(key,"gm_port",29)==0)
	    worldmodel2.gm_port = atoi(value);
          else if (strncasecmp(key,"fs_port",29)==0)
	    worldmodel2.fs_port = atoi(value);
	  break;
        default:
          break;
      }
    }
  }
  fclose(fp);
}

