#ifndef INCLUDED_JointCmd_h
#define INCLUDED_JointCmd_h

//! This object holds all the information needed to control a single output
/*! The name is a bit of a misnomer because it is used to control the LEDs as
 *  well as the joints.  A better name would be OutputCmd... */
struct JointCmd {

	JointCmd() : value(0), weight(0) {} //!< Constructor
	JointCmd(double v, double w) : value(v), weight(w) {} //!< Constructor
	JointCmd(const JointCmd& a, const JointCmd& b, double w) : value(a.value*w+b.value*(1-w)), weight(a.weight*w+b.value*(1-w)) {} //!< Constructor, see set(a,b,w)

	inline void set(double v, double w=1) { value=v; weight=w; } //!< sets the value to @a v and weight to @a w
	inline void set(const JointCmd& a, const JointCmd& b, double w) { value=a.value*w+b.value*(1-w); weight=a.weight*w+b.weight*(1-w); } //!< sets the value to a weighted average of @a a and @a b (higher @a w, more @a a)
	inline void unset() { value=weight=0; } //!< sets value and weight to 0 (same as assigning ::unusedJoint)
	bool operator==(const JointCmd& c) const { return value==c.value && weight==c.weight; } //!< tests for equality of weight and value
	bool operator!=(const JointCmd& c) const { return value!=c.value || weight!=c.weight; } //!< tests for inequality of weight and value

	double value; //!< value of the output
	double weight; //!< weight to be used in averaging, 0 to "fall through"
};

//! a quick way to refer to an empty JointCmd - weight==0, value==0
extern const JointCmd unusedJoint;

/*! @file
 * @brief Describes JointCmd, holds information needed to control a single output
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-0_95 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2003/02/24 10:34:56 $
 */

#endif
