#ifndef INCLUDED_TextMsgEvent_h
#define INCLUDED_TextMsgEvent_h

#include "EventBase.h"

//! Extends EventBase to also include actual message text
class TextMsgEvent : public EventBase {
 public:
	//! Constructor
  TextMsgEvent() : EventBase(EventBase::textmsgEGID,(unsigned int)-1, EventBase::activateETID,0),_token(0) { setText(""); }

  //! Constructor, pass a text msg
  TextMsgEvent(char *text) : EventBase(EventBase::textmsgEGID,(unsigned int)-1, EventBase::activateETID,0),_token(0) { setText(text); }
  
  const char* getText() const { return _text; } //!< returns the text
  TextMsgEvent& setText(char *text) { strncpy(_text, text, 127); return *this; } //!< sets the text
  
  int getToken() const { return _token; } //!< returns the token
  TextMsgEvent& setToken(int token) { _token=token; return *this;} // !< sets the token
      
 protected:
  char _text[128]; //!< the unmodified arguments passed to the command
  int _token;      //!< for future expansion, to support centralized parsing
};

#endif
